/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.location;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.NameableBlockEntity;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.CustomNameableBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.VecHelper;

public final class ServerLocationData {
    private ServerLocationData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ServerLocation.class).create(Keys.BIOME_TEMPERATURE).get(h -> {
            Level world = (Level)h.world();
            BlockPos pos = VecHelper.toBlockPos(h);
            Biome biome = world.getBiome(pos);
            return biome.getBaseTemperature();
        })).create(Keys.BLOCK_LIGHT).get(h -> {
            Level world = (Level)h.world();
            return world.getBrightness(LightLayer.BLOCK, VecHelper.toBlockPos(h));
        })).create(Keys.BLOCK_TEMPERATURE).get(h -> {
            Level world = (Level)h.world();
            BlockPos pos = VecHelper.toBlockPos(h);
            Biome biome = world.getBiome(pos);
            return biome.getTemperature(pos);
        })).create(Keys.SKY_LIGHT).get(h -> {
            Level world = (Level)h.world();
            BlockPos pos = VecHelper.toBlockPos(h);
            return world.getBrightness(LightLayer.SKY, pos);
        })).create(Keys.IS_FULL_BLOCK).get(h -> {
            BlockState block = (BlockState)h.block();
            Level world = (Level)h.world();
            BlockPos pos = VecHelper.toBlockPos(h.position());
            return block.isSolidRender((BlockGetter)world, pos);
        })).create(Keys.IS_INDIRECTLY_POWERED).get(h -> {
            BlockPos pos;
            Level world = (Level)h.world();
            return world.getBestNeighborSignal(pos = VecHelper.toBlockPos(h)) > 0;
        })).create(Keys.DISPLAY_NAME).get(h -> SpongeAdventure.asAdventure(((Nameable)h.blockEntity().get()).getDisplayName()))).supports(h -> h.blockEntity().isPresent() && h.blockEntity().get() instanceof NameableBlockEntity)).create(Keys.CUSTOM_NAME).get(h -> {
            BlockEntity blockEntity = h.blockEntity().get();
            return ((Nameable)blockEntity).hasCustomName() ? SpongeAdventure.asAdventure(((Nameable)blockEntity).getCustomName()) : null;
        })).set((h, v) -> ((CustomNameableBridge)((Object)h.blockEntity().get())).bridge$setCustomDisplayName(SpongeAdventure.asVanilla(v)))).delete(h -> ((CustomNameableBridge)((Object)h.blockEntity().get())).bridge$setCustomDisplayName(null))).supports(h -> h.blockEntity().isPresent() && h.blockEntity().get() instanceof NameableBlockEntity)).create(Keys.CREATOR).get(h -> ((LevelChunkBridge)((Object)((ServerWorld)h.world()).chunk(h.chunkPosition()))).bridge$getBlockCreatorUUID(VecHelper.toBlockPos(h.blockPosition())).orElse(null))).set((h, v) -> ((LevelChunkBridge)((Object)((ServerWorld)h.world()).chunk(h.chunkPosition()))).bridge$setBlockCreator(VecHelper.toBlockPos(h.blockPosition()), (UUID)v))).delete(h -> ((LevelChunkBridge)((Object)((ServerWorld)h.world()).chunk(h.chunkPosition()))).bridge$setBlockCreator(VecHelper.toBlockPos(h.blockPosition()), null))).create(Keys.NOTIFIER).get(h -> ((LevelChunkBridge)((Object)((ServerWorld)h.world()).chunk(h.chunkPosition()))).bridge$getBlockNotifierUUID(VecHelper.toBlockPos(h.blockPosition())).orElse(null))).set((h, v) -> ((LevelChunkBridge)((Object)((ServerWorld)h.world()).chunk(h.chunkPosition()))).bridge$setBlockNotifier(VecHelper.toBlockPos(h.blockPosition()), (UUID)v))).delete(h -> ((LevelChunkBridge)((Object)((ServerWorld)h.world()).chunk(h.chunkPosition()))).bridge$setBlockNotifier(VecHelper.toBlockPos(h.blockPosition()), null));
    }
}

