/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.accessor.world.entity.decoration.ArmorStandAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

public final class ArmorStandData {
    private ArmorStandData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ArmorStand.class).create(Keys.BODY_ROTATIONS).get(h -> {
            HashMap<BodyPart, Vector3d> values = new HashMap<BodyPart, Vector3d>();
            values.put(BodyParts.HEAD.get(), VecHelper.toVector3d(h.getHeadPose()));
            values.put(BodyParts.CHEST.get(), VecHelper.toVector3d(h.getBodyPose()));
            values.put(BodyParts.LEFT_ARM.get(), VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$leftArmPose()));
            values.put(BodyParts.RIGHT_ARM.get(), VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$rightArmPose()));
            values.put(BodyParts.LEFT_LEG.get(), VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$leftLegPose()));
            values.put(BodyParts.RIGHT_LEG.get(), VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$rightLegPose()));
            return values;
        })).set((h, v) -> {
            ArmorStandData.apply(v, BodyParts.HEAD.get(), arg_0 -> ((ArmorStand)h).setHeadPose(arg_0));
            ArmorStandData.apply(v, BodyParts.CHEST.get(), arg_0 -> ((ArmorStand)h).setBodyPose(arg_0));
            ArmorStandData.apply(v, BodyParts.LEFT_ARM.get(), arg_0 -> ((ArmorStand)h).setLeftArmPose(arg_0));
            ArmorStandData.apply(v, BodyParts.RIGHT_ARM.get(), arg_0 -> ((ArmorStand)h).setRightArmPose(arg_0));
            ArmorStandData.apply(v, BodyParts.LEFT_LEG.get(), arg_0 -> ((ArmorStand)h).setLeftLegPose(arg_0));
            ArmorStandData.apply(v, BodyParts.RIGHT_LEG.get(), arg_0 -> ((ArmorStand)h).setRightLegPose(arg_0));
        })).create(Keys.CHEST_ROTATION).get(h -> VecHelper.toVector3d(h.getBodyPose()))).set((h, v) -> h.setBodyPose(VecHelper.toRotation(v)))).create(Keys.HAS_ARMS).get(ArmorStand::isShowArms)).set((h, v) -> ((ArmorStandAccessor)h).invoker$setShowArms((boolean)v))).create(Keys.HAS_BASE_PLATE).get(h -> !h.isNoBasePlate())).set((h, v) -> ((ArmorStandAccessor)h).invoker$setNoBasePlate(v == false))).create(Keys.HAS_MARKER).get(ArmorStand::isMarker)).set((h, v) -> ((ArmorStandAccessor)h).invoker$setMarker((boolean)v))).create(Keys.HEAD_ROTATION).get(h -> VecHelper.toVector3d(h.getHeadPose()))).set((h, v) -> h.setHeadPose(VecHelper.toRotation(v)))).create(Keys.IS_PLACING_DISABLED).get(h -> Sponge.game().registry(RegistryTypes.EQUIPMENT_TYPE).streamEntries().map(RegistryEntry::value).collect(Collectors.toMap(k -> k, v -> ((ArmorStandAccessor)h).invoker$isDisabled((EquipmentSlot)v))))).set((h, v) -> {
            int chunk = 0;
            int disabledSlots = ((ArmorStandAccessor)h).accessor$disabledSlots();
            int allChunk = disabledSlots & 0xFF;
            if (allChunk != 0) {
                disabledSlots |= allChunk << 16;
                disabledSlots ^= 0xFF;
            }
            if (((Boolean)v.get(EquipmentTypes.MAIN_HAND.get())).booleanValue()) {
                chunk |= 1;
            }
            if (((Boolean)v.get(EquipmentTypes.FEET.get())).booleanValue()) {
                chunk |= 2;
            }
            if (((Boolean)v.get(EquipmentTypes.LEGS.get())).booleanValue()) {
                chunk |= 4;
            }
            if (((Boolean)v.get(EquipmentTypes.CHEST.get())).booleanValue()) {
                chunk |= 8;
            }
            if (((Boolean)v.get(EquipmentTypes.HEAD.get())).booleanValue()) {
                chunk |= 0x10;
            }
            if (((Boolean)v.get(EquipmentTypes.OFF_HAND.get())).booleanValue()) {
                chunk |= 0x20;
            }
            ((ArmorStandAccessor)h).accessor$disabledSlots(disabledSlots |= chunk << 16);
        })).create(Keys.IS_SMALL).get(ArmorStand::isSmall)).set((h, v) -> ((ArmorStandAccessor)h).invoker$setSmall((boolean)v))).create(Keys.IS_TAKING_DISABLED).get(h -> {
            int disabled = ((ArmorStandAccessor)h).accessor$disabledSlots();
            int resultantChunk = disabled >> 16 & 0xFF | disabled & 0xFF;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            return builder.put((Object)EquipmentTypes.MAIN_HAND.get(), (Object)((resultantChunk & 1) != 0 ? 1 : 0)).put((Object)EquipmentTypes.FEET.get(), (Object)((resultantChunk & 2) != 0 ? 1 : 0)).put((Object)EquipmentTypes.LEGS.get(), (Object)((resultantChunk & 4) != 0 ? 1 : 0)).put((Object)EquipmentTypes.CHEST.get(), (Object)((resultantChunk & 8) != 0 ? 1 : 0)).put((Object)EquipmentTypes.HEAD.get(), (Object)((resultantChunk & 0x10) != 0 ? 1 : 0)).put((Object)EquipmentTypes.OFF_HAND.get(), (Object)((resultantChunk & 0x20) != 0 ? 1 : 0)).build();
        })).set((h, v) -> {
            int chunk = 0;
            int disabledSlots = ((ArmorStandAccessor)h).accessor$disabledSlots();
            int allChunk = disabledSlots & 0xFF;
            if (allChunk != 0) {
                disabledSlots |= allChunk << 16;
                ((ArmorStandAccessor)h).accessor$disabledSlots(disabledSlots ^= 0xFF);
            }
            if (((Boolean)v.get(EquipmentTypes.MAIN_HAND.get())).booleanValue()) {
                chunk |= 1;
            }
            if (((Boolean)v.get(EquipmentTypes.FEET.get())).booleanValue()) {
                chunk |= 2;
            }
            if (((Boolean)v.get(EquipmentTypes.LEGS.get())).booleanValue()) {
                chunk |= 4;
            }
            if (((Boolean)v.get(EquipmentTypes.CHEST.get())).booleanValue()) {
                chunk |= 8;
            }
            if (((Boolean)v.get(EquipmentTypes.HEAD.get())).booleanValue()) {
                chunk |= 0x10;
            }
            if (((Boolean)v.get(EquipmentTypes.OFF_HAND.get())).booleanValue()) {
                chunk |= 0x20;
            }
            ((ArmorStandAccessor)h).accessor$disabledSlots(disabledSlots |= chunk << 8);
        })).create(Keys.LEFT_ARM_ROTATION).get(h -> VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$leftArmPose()))).set((h, v) -> h.setLeftArmPose(VecHelper.toRotation(v)))).create(Keys.LEFT_LEG_ROTATION).get(h -> VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$leftLegPose()))).set((h, v) -> h.setLeftLegPose(VecHelper.toRotation(v)))).create(Keys.RIGHT_ARM_ROTATION).get(h -> VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$rightArmPose()))).set((h, v) -> h.setRightArmPose(VecHelper.toRotation(v)))).create(Keys.RIGHT_LEG_ROTATION).get(h -> VecHelper.toVector3d(((ArmorStandAccessor)h).accessor$rightLegPose()))).set((h, v) -> h.setRightLegPose(VecHelper.toRotation(v)));
    }

    private static void apply(Map<BodyPart, Vector3d> value, BodyPart part, Consumer<Rotations> consumer) {
        Vector3d vec = value.get(part);
        if (vec == null) {
            return;
        }
        consumer.accept(VecHelper.toRotation(vec));
    }
}

