/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import java.util.Objects;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import org.spongepowered.api.entity.ai.goal.builtin.creature.RangedAttackAgainstAgentGoal;
import org.spongepowered.api.entity.living.Ranger;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.util.SpongeTicks;

public final class SpongeRangedAttackAgainstAgentGoalBuilder
implements RangedAttackAgainstAgentGoal.Builder {
    private double maxSpeed;
    private Ticks delayBetweenAttacks = Ticks.zero();
    private float attackRadius;

    public SpongeRangedAttackAgainstAgentGoalBuilder() {
        this.reset();
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder moveSpeed(double speed) {
        this.maxSpeed = speed;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder delayBetweenAttacks(Ticks delay) {
        this.delayBetweenAttacks = delay;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder attackRadius(float radius) {
        this.attackRadius = radius;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder from(RangedAttackAgainstAgentGoal value) {
        Objects.requireNonNull(value);
        this.maxSpeed = value.moveSpeed();
        this.delayBetweenAttacks = value.delayBetweenAttacks();
        this.attackRadius = value.attackRadius();
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder reset() {
        this.maxSpeed = 1.25;
        this.delayBetweenAttacks = new SpongeTicks(20L);
        this.attackRadius = 10.0f;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal build(Ranger owner) {
        Objects.requireNonNull(owner);
        if (!(owner instanceof RangedAttackMob)) {
            throw new IllegalArgumentException("Ranger must be an IRangedAttackMob!");
        }
        return (RangedAttackAgainstAgentGoal)new RangedAttackGoal((RangedAttackMob)owner, this.maxSpeed, (int)this.delayBetweenAttacks.ticks(), this.attackRadius);
    }
}

