/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.lifecycle;

import io.leangen.geantyref.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.lifecycle.RegisterRegistryEvent;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.registry.RegistryRoots;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.event.lifecycle.AbstractLifecycleEvent;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.registry.SpongeRegistryHolder;

public abstract class AbstractRegisterRegistryEvent
extends AbstractLifecycleEvent
implements RegisterRegistryEvent {
    public AbstractRegisterRegistryEvent(Cause cause, Game game) {
        super(cause, game);
    }

    @Override
    public <T> RegistryType<T> register(ResourceKey key, boolean isDynamic) throws DuplicateRegistrationException {
        Objects.requireNonNull(key, "key");
        SpongeRegistryHolder holder = this.getHolder();
        RegistryType type = RegistryType.of(RegistryRoots.SPONGE, key);
        holder.createRegistry(type, (RegistryLoader)null, isDynamic);
        return type;
    }

    @Override
    public <T> RegistryType<T> register(ResourceKey key, boolean isDynamic, Supplier<Map<ResourceKey, T>> defaultValues) throws DuplicateRegistrationException {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(defaultValues, "defaultValues");
        SpongeRegistryHolder holder = this.getHolder();
        RegistryType type = RegistryType.of(RegistryRoots.SPONGE, key);
        holder.createRegistry(type, defaultValues, isDynamic);
        return type;
    }

    protected abstract SpongeRegistryHolder getHolder();

    public static final class WorldScopedImpl
    extends AbstractRegisterRegistryEvent
    implements RegisterRegistryEvent.WorldScoped {
        private final ResourceKey worldKey;

        public WorldScopedImpl(Cause cause, Game game, ResourceKey worldKey) {
            super(cause, game);
            this.worldKey = worldKey;
        }

        @Override
        public ResourceKey worldKey() {
            return this.worldKey;
        }

        @Override
        protected SpongeRegistryHolder getHolder() {
            return (SpongeRegistryHolder)((Object)this.game.server().worldManager().world(this.worldKey).get());
        }
    }

    public static final class EngineScopedImpl<E extends Engine>
    extends AbstractRegisterRegistryEvent
    implements RegisterRegistryEvent.EngineScoped<E> {
        private final TypeToken<E> token;
        private final E engine;

        public EngineScopedImpl(Cause cause, Game game, E engine) {
            super(cause, game);
            this.token = TypeToken.get(engine.getClass());
            this.engine = engine;
        }

        @Override
        public TypeToken<E> paramType() {
            return this.token;
        }

        @Override
        protected SpongeRegistryHolder getHolder() {
            return (SpongeRegistryHolder)this.engine;
        }
    }

    public static final class GameScopedImpl
    extends AbstractRegisterRegistryEvent
    implements RegisterRegistryEvent.GameScoped {
        public GameScopedImpl(Cause cause, Game game) {
            super(cause, game);
        }

        @Override
        protected SpongeRegistryHolder getHolder() {
            return (SpongeRegistryHolder)((Object)this.game);
        }
    }
}

