/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.ipforward.velocity;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.kyori.adventure.text.Component;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelExceptionHandler;
import org.spongepowered.api.network.channel.NoResponseException;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.handshake.RawHandshakeDataChannel;
import org.spongepowered.common.accessor.network.ConnectionAccessor;
import org.spongepowered.common.accessor.server.network.ServerLoginPacketListenerImplAccessor;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;

public class VelocityForwardingInfo {
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    private static final Logger LOGGER = LogManager.getLogger();

    public static void sendQuery(ServerLoginPacketListenerImpl mcConn) {
        EngineConnection conn = (EngineConnection)mcConn;
        ((CompletableFuture)VelocityChannel.CHANNEL.sendTo(conn, cbuf -> {}).whenComplete((response, error) -> {
            if (error != null) {
                if (error instanceof NoResponseException) {
                    conn.close((Component)Component.text((String)"This server requires you to connect with Velocity."));
                }
                return;
            }
            if (!VelocityForwardingInfo.checkIntegrity(response)) {
                conn.close((Component)Component.text((String)"Unable to verify player details. Is your forwarding secret correct?"));
                return;
            }
            ConnectionAccessor connectionAccessor = (ConnectionAccessor)mcConn.getConnection();
            connectionAccessor.accessor$address(new InetSocketAddress(VelocityForwardingInfo.readAddress(response), ((InetSocketAddress)mcConn.getConnection().getRemoteAddress()).getPort()));
            ((ServerLoginPacketListenerImplAccessor)mcConn).accessor$gameProfile(VelocityForwardingInfo.createProfile(response));
        })).exceptionally(err -> {
            if (!(err instanceof NoResponseException)) {
                LOGGER.error("Failed to process velocity forwarding info", err);
                conn.close((Component)Component.text((String)"Invalid forwarding information received!"));
            }
            return null;
        });
    }

    public static boolean checkIntegrity(ChannelBuf buf) {
        byte[] signature = buf.readBytes(32);
        byte[] data = new byte[buf.available()];
        ((ByteBuf)buf).getBytes(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(SpongeConfigs.getCommon().get().ipForwarding.secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        int version = buf.readVarInt();
        if (version != 1) {
            throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted 1");
        }
        return true;
    }

    public static InetAddress readAddress(ChannelBuf buf) {
        return InetAddresses.forString((String)buf.readString());
    }

    public static GameProfile createProfile(ChannelBuf buf) {
        GameProfile profile = new GameProfile(buf.readUniqueId(), ((FriendlyByteBuf)buf).readUtf(16));
        VelocityForwardingInfo.readProperties(buf, profile);
        return profile;
    }

    private static void readProperties(ChannelBuf buf, GameProfile profile) {
        int properties = buf.readVarInt();
        for (int i1 = 0; i1 < properties; ++i1) {
            String name = buf.readString();
            String value = buf.readString();
            String signature = buf.readBoolean() ? buf.readString() : null;
            profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
        }
    }

    private static class VelocityChannel {
        private static final ResourceKey PLAYER_INFO_CHANNEL = ResourceKey.of("velocity", "player_info");
        private static final RawHandshakeDataChannel CHANNEL;

        private VelocityChannel() {
        }

        static {
            RawDataChannel rawData = Sponge.channelManager().ofType(PLAYER_INFO_CHANNEL, RawDataChannel.class);
            rawData.setExceptionHandler(ChannelExceptionHandler.logEverything().suppressIfFutureIsPresent(NoResponseException.class));
            CHANNEL = rawData.handshake();
        }
    }
}

