/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class SpongeFurnaceRecipe
extends SmeltingRecipe {
    private final Function<Container, ItemStack> resultFunction;

    public SpongeFurnaceRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<Container, ItemStack> resultFunction) {
        super(id, group, ingredient, result, experience, cookingTime);
        this.resultFunction = resultFunction;
    }

    public ItemStack assemble(Container container) {
        if (this.resultFunction != null) {
            ItemStack result = this.resultFunction.apply(container);
            result.setCount(1);
            return result;
        }
        return super.assemble(container);
    }

    public ItemStack getResultItem() {
        if (this.resultFunction != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem();
    }
}

