/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.sound.Sound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCustomSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeMusicDisc;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.level.chunk.SpongeEmptyChunk;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={Level.class})
public abstract class LevelMixin_API<W extends World<W, L>, L extends Location<W, L>>
implements World<W, L>,
SpongeRegistryHolder,
AutoCloseable {
    @Shadow
    @Final
    public Random random;
    @Shadow
    @Final
    protected List<TickingBlockEntity> blockEntityTickers;
    private Context api$context;
    private RegistryHolderLogic api$registryHolder;
    protected @MonotonicNonNull SpongeChunkLayout api$chunkLayout;

    @Shadow
    public abstract @org.checkerframework.checker.nullness.qual.Nullable MinecraftServer shadow$getServer();

    @Shadow
    public abstract BlockState shadow$getBlockState(BlockPos var1);

    @Shadow
    public abstract void shadow$playSound(@Nullable net.minecraft.world.entity.player.Player var1, double var2, double var4, double var6, SoundEvent var8, SoundSource var9, float var10, float var11);

    @Shadow
    public abstract LevelData shadow$getLevelData();

    @Shadow
    public abstract void shadow$removeBlockEntity(BlockPos var1);

    @Shadow
    public abstract ResourceKey<Level> shadow$dimension();

    @Shadow
    public abstract void shadow$setBlockEntity(BlockEntity var1);

    @Shadow
    public abstract LevelChunk shadow$getChunkAt(BlockPos var1);

    @Shadow
    public abstract List<net.minecraft.world.entity.Entity> shadow$getEntities(@org.jetbrains.annotations.Nullable net.minecraft.world.entity.Entity var1, AABB var2, @org.jetbrains.annotations.Nullable Predicate<? super net.minecraft.world.entity.Entity> var3);

    @Shadow
    public abstract <T extends net.minecraft.world.entity.Entity> List<T> shadow$getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> var1, AABB var2, @org.jetbrains.annotations.Nullable Predicate<? super T> var3);

    @Override
    public Optional<? extends Player> closestPlayer(int x, int y, int z, double distance, Predicate<? super Player> predicate) {
        return Optional.ofNullable((Player)((Level)this).getNearestPlayer((double)x, (double)y, (double)z, distance, Objects.requireNonNull(predicate, "predicate")));
    }

    @Override
    public WorldChunk chunk(int cx, int cy, int cz) {
        ChunkAccess chunk = ((Level)this).getChunk(cx, cz, ChunkStatus.EMPTY, true);
        if (chunk instanceof WorldChunk) {
            return (WorldChunk)chunk;
        }
        if (chunk instanceof ImposterProtoChunk) {
            return (WorldChunk)((ImposterProtoChunk)chunk).getWrapped();
        }
        return new SpongeEmptyChunk((Level)this, chunk);
    }

    @Override
    public Optional<WorldChunk> loadChunk(int cx, int cy, int cz, boolean shouldGenerate) {
        ChunkStatus status;
        if (!this.api$chunkLayout().isValidChunk(cx, cy, cz)) {
            return Optional.empty();
        }
        ChunkSource chunkProvider = ((LevelAccessor)this).getChunkSource();
        @org.checkerframework.checker.nullness.qual.Nullable ChunkAccess chunkAccess = chunkProvider.getChunk(cx, cz, status = shouldGenerate ? ChunkStatus.FULL : ChunkStatus.EMPTY, true);
        if (chunkAccess == null) {
            return Optional.empty();
        }
        if (chunkAccess instanceof ImposterProtoChunk) {
            return Optional.of((WorldChunk)((ImposterProtoChunk)chunkAccess).getWrapped());
        }
        if (chunkAccess instanceof WorldChunk) {
            return Optional.of((WorldChunk)chunkAccess);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<WorldChunk> loadedChunks() {
        ChunkSource chunkProvider = ((LevelAccessor)this).getChunkSource();
        if (chunkProvider instanceof ServerChunkCache) {
            ChunkMapAccessor chunkManager = (ChunkMapAccessor)((ServerChunkCache)chunkProvider).chunkMap;
            ArrayList<WorldChunk> chunks = new ArrayList<WorldChunk>();
            chunkManager.invoker$getChunks().forEach(holder -> {
                WorldChunk chunk = (WorldChunk)holder.getTickingChunk();
                if (chunk != null) {
                    chunks.add(chunk);
                }
            });
            return chunks;
        }
        return Collections.emptyList();
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        if (this.api$registryHolder == null) {
            this.api$registryHolder = new RegistryHolderLogic(((LevelAccessor)this).registryAccess());
        }
        return this.api$registryHolder;
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.height(HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    public Vector3i min() {
        return this.api$chunkLayout().spaceMin();
    }

    @Override
    public Vector3i max() {
        return this.api$chunkLayout().spaceMin();
    }

    @Override
    public Vector3i size() {
        return this.api$chunkLayout().spaceSize();
    }

    private SpongeChunkLayout api$chunkLayout() {
        if (this.api$chunkLayout == null) {
            int min = ((Level)this).getMinBuildHeight();
            int height = ((Level)this).getHeight();
            this.api$chunkLayout = new SpongeChunkLayout(min, height);
        }
        return this.api$chunkLayout;
    }

    @Override
    public Context context() {
        if (this.api$context == null) {
            this.api$context = new Context("world", this.shadow$dimension().location().toString());
        }
        return this.api$context;
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        Objects.requireNonNull(particleEffect, "particleEffect");
        Objects.requireNonNull(position, "position");
        if (radius <= 0) {
            throw new IllegalArgumentException("The radius has to be greater then zero!");
        }
        SpongeParticleHelper.sendPackets(particleEffect, position, radius, this.shadow$dimension(), this.shadow$getServer().getPlayerList());
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc musicDisc) {
        this.api$playRecord(Objects.requireNonNull(position, "position"), Objects.requireNonNull(musicDisc, "musicDisc"));
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.api$playRecord(Objects.requireNonNull(position, "position"), null);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, org.spongepowered.api.block.BlockState state) {
        Objects.requireNonNull(state, "state");
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(new BlockPos(x, y, z), (BlockState)state);
        ((Level)this).players().stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).forEach(p -> p.connection.send((Packet)packet));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket((BlockGetter)((LevelReader)this), new BlockPos(x, y, z));
        ((Level)this).players().stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).forEach(p -> p.connection.send((Packet)packet));
    }

    public void playSound(Sound sound, double x, double y, double z) {
        ResourceLocation soundKey = SpongeAdventure.asVanilla(sound.name());
        Optional event = Registry.SOUND_EVENT.getOptional(soundKey);
        SoundSource soundCategory = SpongeAdventure.asVanilla(sound.source());
        if (event.isPresent()) {
            this.shadow$playSound(null, x, y, z, (SoundEvent)event.get(), soundCategory, sound.volume(), sound.pitch());
        } else {
            float volume = sound.volume();
            double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
            ClientboundCustomSoundPacket packet = new ClientboundCustomSoundPacket(soundKey, soundCategory, new Vec3(x, y, z), volume, sound.pitch());
            this.shadow$getServer().getPlayerList().broadcast(null, x, y, z, radius, this.shadow$dimension(), (Packet)packet);
        }
    }

    @Override
    public Collection<? extends org.spongepowered.api.block.entity.BlockEntity> blockEntities() {
        return Collections.emptyList();
    }

    @Override
    public void addBlockEntity(int x, int y, int z, org.spongepowered.api.block.entity.BlockEntity blockEntity) {
        this.shadow$setBlockEntity((BlockEntity)Objects.requireNonNull(blockEntity, "blockEntity"));
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((LevelBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), false);
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((LevelBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), true);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container) {
        return (Optional)((LevelBridge)((Object)this)).bridge$createEntity(container, null, null);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        return Optional.ofNullable(((LevelBridge)((Object)this)).bridge$createEntity(container, position, null));
    }

    @Override
    public ArchetypeVolume createArchetypeVolume(Vector3i min, Vector3i max, Vector3i origin) {
        Vector3i rawVolMin = Objects.requireNonNull(min, "min").min(Objects.requireNonNull(max, "max"));
        Vector3i volMax = max.max(min);
        Vector3i size = volMax.sub(rawVolMin).add(1, 1, 1);
        Vector3i relativeMin = rawVolMin.sub(Objects.requireNonNull(origin, "origin"));
        SpongeArchetypeVolume volume = new SpongeArchetypeVolume(relativeMin, size, this);
        this.blockStateStream(min, max, StreamOptions.lazily()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBlocks()));
        this.blockEntityStream(min, max, StreamOptions.lazily()).map((world, blockEntity, x, y, z) -> ((org.spongepowered.api.block.entity.BlockEntity)blockEntity.get()).createArchetype()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBlockEntityArchetypes()));
        this.biomeStream(min, max, StreamOptions.lazily()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBiomes()));
        this.entityStream(min, max, StreamOptions.lazily()).filter((world, entity, x, y, z) -> ((EntityAccessor)entity.get()).invoker$getEncodeId() != null || ((Entity)entity.get()).type() == HumanEntity.TYPE).map((world, entity, x, y, z) -> ((Entity)entity.get()).createArchetype()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyEntityArchetypes()));
        return volume;
    }

    private void api$playRecord(Vector3i position, @Nullable MusicDisc recordType) {
        this.shadow$getServer().getPlayerList().broadcastAll((Packet)SpongeMusicDisc.createPacket(position, recordType), this.shadow$dimension());
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of Level that isn't part of Sponge API");
    }

    @Override
    public Collection<? extends Player> players() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of Level that isn't part of Sponge API");
    }

    @Override
    public VolumeStream<W, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(min, max, options, this, VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, (Level)this), VolumeStreamUtils.getChunkAccessorByStatus((LevelReader)this, options.loadingStyle().generateArea()), (key, entity) -> entity.getUUID(), chunk -> chunk instanceof LevelChunk ? VolumeStreamUtils.getEntitiesFromChunk(min, max, (LevelChunk)chunk) : Stream.empty(), (entityUuid, world) -> {
            net.minecraft.world.entity.Entity entity;
            net.minecraft.world.entity.Entity entity2 = entity = shouldCarbonCopy ? (net.minecraft.world.entity.Entity)backingVolume.entity((UUID)entityUuid).orElse(null) : (net.minecraft.world.entity.Entity)world.entity((UUID)entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new Tuple((Object)entity.blockPosition(), (Object)entity);
        });
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        if (!((Level)this).hasChunk(x << 4, z << 4)) {
            return false;
        }
        LevelChunk levelChunk = this.shadow$getChunkAt(new BlockPos(x, y, z));
        return ((BiomeVolume.Modifiable)levelChunk).setBiome(x, y, z, biome);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!this.spawnEntity(entity)) continue;
            entityList.add(entity);
        }
        return entityList;
    }

    @Override
    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, org.spongepowered.api.util.AABB box, @org.checkerframework.checker.nullness.qual.Nullable Predicate<? super T> filter) {
        return this.shadow$getEntities(EntityTypeTest.forClass(entityClass), VecHelper.toMinecraftAABB(box), filter);
    }

    @Override
    public Collection<? extends Entity> entities(org.spongepowered.api.util.AABB box, Predicate<? super Entity> filter) {
        return this.shadow$getEntities((net.minecraft.world.entity.Entity)null, VecHelper.toMinecraftAABB(box), filter);
    }
}

