/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.block.DyeColorBlockBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.ReflectionUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={Block.class})
public abstract class BlockMixin
implements BlockBridge,
TrackableBridge {
    private final boolean impl$isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private final boolean impl$hasCollideLogic = ReflectionUtil.isStepOnDeclared(this.getClass());
    private final boolean impl$hasCollideWithStateLogic = ReflectionUtil.isEntityInsideDeclared(this.getClass());

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setUpSpongeFields(BlockBehaviour.Properties properties, CallbackInfo ci) {
        ((DyeColorBlockBridge)((Object)this)).bridge$setDyeColor(((DyeColorBlockBridge)properties).bridge$getDyeColor().orElse(null));
    }

    @Inject(method={"popResource(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;popResource(Lnet/minecraft/world/level/Level;Ljava/util/function/Supplier;Lnet/minecraft/world/item/ItemStack;)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, require=0, expect=0)
    private static void impl$throwConstructPreEvent(Level level, BlockPos pos, ItemStack stack, CallbackInfo ci, float $$3, double xPos, double yPos, double zPos) {
        if (!ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(level.getBlockState(pos));
            ConstructEntityEvent.Pre eventPre = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)level, xPos, yPos, zPos), Vector3d.ZERO, EntityTypes.ITEM.get());
            SpongeCommon.post(eventPre);
            if (eventPre.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"popResourceFromFace(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;popResource(Lnet/minecraft/world/level/Level;Ljava/util/function/Supplier;Lnet/minecraft/world/item/ItemStack;)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void impl$throwConstructPreEvent(Level level, BlockPos pos, Direction direction, ItemStack stack, CallbackInfo ci, int stepX, int stepY, int stepZ, float itemWidthX, float itemWidthZ, double xPos, double yPos, double zPos, double xMov, double yMov, double zMov) {
        if (!ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(level.getBlockState(pos));
            ConstructEntityEvent.Pre eventPre = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)level, xPos, yPos, zPos), new Vector3d(xMov, yMov, zMov), EntityTypes.ITEM.get());
            SpongeCommon.post(eventPre);
            if (eventPre.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Override
    public boolean bridge$isVanilla() {
        return this.impl$isVanilla;
    }

    @Override
    public boolean bridge$hasCollideLogic() {
        return this.impl$hasCollideLogic;
    }

    @Override
    public boolean bridge$hasCollideWithStateLogic() {
        return this.impl$hasCollideWithStateLogic;
    }
}

