/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.server.commands.DifficultyCommand;
import net.minecraft.world.level.storage.LevelData;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;

@Mixin(value={DifficultyCommand.class})
public abstract class DifficultyCommandMixin {
    @Shadow
    @Final
    private static DynamicCommandExceptionType ERROR_ALREADY_DIFFICULT;

    @Overwrite
    public static int setDifficulty(CommandSourceStack source, net.minecraft.world.Difficulty difficulty) throws CommandSyntaxException {
        if (source.getLevel().getDifficulty() == difficulty) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)difficulty.getKey());
        }
        LevelData levelData = source.getLevel().getLevelData();
        ((ServerWorldProperties)levelData).setDifficulty((Difficulty)difficulty);
        source.getLevel().setSpawnSettings(((MinecraftServerAccessor)SpongeCommon.server()).invoker$isSpawningMonsters(), SpongeCommon.server().isSpawningAnimals());
        source.getLevel().getPlayers(p -> true).forEach(p -> p.connection.send((Packet)new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked())));
        source.sendSuccess((Component)new TranslatableComponent("commands.difficulty.success", new Object[]{difficulty.getDisplayName()}), true);
        return 0;
    }
}

