/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZonedDateTime;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.data.persistence.DataSerializers;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.world.schematic.SchematicTranslator;
import org.spongepowered.math.imaginary.Complexd;
import org.spongepowered.math.imaginary.Complexf;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.imaginary.Quaternionf;
import org.spongepowered.math.vector.Vector2d;
import org.spongepowered.math.vector.Vector2f;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.math.vector.Vector2l;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3f;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vector3l;
import org.spongepowered.math.vector.Vector4d;
import org.spongepowered.math.vector.Vector4f;
import org.spongepowered.math.vector.Vector4i;
import org.spongepowered.math.vector.Vector4l;

public final class DataTranslatorProvider {
    public static final DataTranslatorProvider INSTANCE = new DataTranslatorProvider();
    private final Map<Class, DataTranslator> mappings = new IdentityHashMap<Class, DataTranslator>();

    DataTranslatorProvider() {
        this.mappings.put(Component.class, DataSerializers.COMPONENT_DATA_SERIALIZER);
        this.mappings.put(UUID.class, DataSerializers.UUID_DATA_SERIALIZER);
        this.mappings.put(Vector2d.class, DataSerializers.VECTOR_2_D_DATA_SERIALIZER);
        this.mappings.put(Vector2f.class, DataSerializers.VECTOR_2_F_DATA_SERIALIZER);
        this.mappings.put(Vector2i.class, DataSerializers.VECTOR_2_I_DATA_SERIALIZER);
        this.mappings.put(Vector2l.class, DataSerializers.VECTOR_2_L_DATA_SERIALIZER);
        this.mappings.put(Vector3d.class, DataSerializers.VECTOR_3_D_DATA_SERIALIZER);
        this.mappings.put(Vector3f.class, DataSerializers.VECTOR_3_F_DATA_SERIALIZER);
        this.mappings.put(Vector3i.class, DataSerializers.VECTOR_3_I_DATA_SERIALIZER);
        this.mappings.put(Vector3l.class, DataSerializers.VECTOR_3_L_DATA_SERIALIZER);
        this.mappings.put(Vector4d.class, DataSerializers.VECTOR_4_D_DATA_SERIALIZER);
        this.mappings.put(Vector4f.class, DataSerializers.VECTOR_4_F_DATA_SERIALIZER);
        this.mappings.put(Vector4i.class, DataSerializers.VECTOR_4_I_DATA_SERIALIZER);
        this.mappings.put(Vector4l.class, DataSerializers.VECTOR_4_L_DATA_SERIALIZER);
        this.mappings.put(Complexd.class, DataSerializers.COMPLEXD_DATA_SERIALIZER);
        this.mappings.put(Complexf.class, DataSerializers.COMPLEXF_DATA_SERIALIZER);
        this.mappings.put(Quaterniond.class, DataSerializers.QUATERNIOND_DATA_SERIALIZER);
        this.mappings.put(Quaternionf.class, DataSerializers.QUATERNIONF_DATA_SERIALIZER);
        this.mappings.put(LocalTime.class, DataSerializers.LOCAL_TIME_DATA_SERIALIZER);
        this.mappings.put(LocalDate.class, DataSerializers.LOCAL_DATE_DATA_SERIALIZER);
        this.mappings.put(LocalDateTime.class, DataSerializers.LOCAL_DATE_TIME_DATA_SERIALIZER);
        this.mappings.put(Instant.class, DataSerializers.INSTANT_DATA_SERIALIZER);
        this.mappings.put(ZonedDateTime.class, DataSerializers.ZONED_DATE_TIME_DATA_SERIALIZER);
        this.mappings.put(Month.class, DataSerializers.MONTH_DATA_SERIALIZER);
        this.mappings.put(CompoundTag.class, NBTTranslator.INSTANCE);
        this.mappings.put(Schematic.class, SchematicTranslator.get());
        this.mappings.put(Direction.class, DataSerializers.DIRECTION_SERIALIZER);
    }

    public <T> Optional<DataTranslator<T>> getSerializer(Class clazz) {
        DataTranslator dataTranslator = this.mappings.get(clazz);
        return Optional.ofNullable(dataTranslator);
    }
}

