/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.tag;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.tag.TagTemplate;
import org.spongepowered.api.tag.TagType;
import org.spongepowered.api.tag.Taggable;
import org.spongepowered.common.tag.SpongeTagTemplate;

public final class SpongeTagTemplateBuilder<T extends Taggable<T>>
implements TagTemplate.Builder<T> {
    private final TagType<T> tagType;
    private @Nullable ResourceKey key;
    private boolean replace = false;
    private final Map<ResourceKey, Boolean> values = new HashMap<ResourceKey, Boolean>();
    private final Map<ResourceKey, Boolean> children = new HashMap<ResourceKey, Boolean>();

    public SpongeTagTemplateBuilder(TagType<T> tagType) {
        this.tagType = tagType;
    }

    @Override
    public TagTemplate.Builder<T> key(ResourceKey key) {
        this.key = key;
        return this;
    }

    @Override
    public TagTemplate.Builder<T> replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    @Override
    public TagTemplate.Builder<T> addChild(RegistryKey<Tag<T>> childTag, boolean required) {
        this.children.put(childTag.location(), required);
        return this;
    }

    @Override
    public TagTemplate.Builder<T> addChild(TagTemplate childTag) throws IllegalArgumentException {
        SpongeTagTemplate spongeTagTemplate = (SpongeTagTemplate)childTag;
        if (spongeTagTemplate.tagType() != this.tagType) {
            throw new IllegalArgumentException("TagTemplate given is not compatible with this builder, it is for a different type!");
        }
        if (spongeTagTemplate.subTags().containsKey(this.key)) {
            throw new IllegalArgumentException("Recursive tag reference detected! Cannot add a child tag with parent as child! Key: " + this.key);
        }
        this.children.put(childTag.key(), true);
        return this;
    }

    @Override
    public TagTemplate.Builder<T> addChildren(Collection<RegistryKey<Tag<T>>> children, boolean required) {
        children.stream().map(RegistryKey::location).forEach(key -> this.children.put((ResourceKey)key, required));
        return this;
    }

    @Override
    public TagTemplate.Builder<T> addChildren(Map<RegistryKey<Tag<T>>, Boolean> childrenMap) {
        childrenMap.forEach((k, v) -> this.children.put(k.location(), (Boolean)v));
        return this;
    }

    @Override
    public TagTemplate.Builder<T> addValue(RegistryKey<T> value, boolean required) throws IllegalArgumentException {
        this.values.put(value.location(), required);
        return this;
    }

    @Override
    public TagTemplate.Builder<T> addValues(Collection<RegistryKey<T>> values, boolean required) throws IllegalArgumentException {
        values.forEach(v -> this.values.put(v.location(), required));
        return this;
    }

    @Override
    public @NonNull SpongeTagTemplate build() {
        if (this.key == null) {
            throw new IllegalStateException("Key has not been provided yet!");
        }
        return new SpongeTagTemplate(this.key, this.tagType, this.replace, (Map<ResourceKey, Boolean>)ImmutableMap.copyOf(this.values), (Map<ResourceKey, Boolean>)ImmutableMap.copyOf(this.children));
    }

    @Override
    public TagTemplate.Builder<T> reset() {
        this.replace = false;
        this.values.clear();
        this.children.clear();
        return this;
    }
}

