/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.raytrace.AbstractSpongeRayTrace;
import org.spongepowered.common.util.raytrace.SpongeRayTraceResult;

public final class SpongeEntityRayTrace
extends AbstractSpongeRayTrace<Entity> {
    private static final Predicate<Entity> DEFAULT_FILTER = entity -> true;

    public SpongeEntityRayTrace() {
        super(DEFAULT_FILTER);
    }

    @Override
    boolean requiresEntityTracking() {
        return true;
    }

    @Override
    List<net.minecraft.world.entity.Entity> selectEntities(ServerWorld serverWorld, AABB targetAABB) {
        return ((Level)serverWorld).getEntities((net.minecraft.world.entity.Entity)null, targetAABB, this.select);
    }

    @Override
    final Optional<RayTraceResult<@NonNull Entity>> testSelectLocation(ServerWorld serverWorld, Vec3 vec3din, Vec3 vec3dend) {
        double currentSqDist = Double.MAX_VALUE;
        SpongeRayTraceResult<Entity> returnedEntity = null;
        LocatableBlock locatableBlock = this.getBlock(serverWorld, vec3din, vec3dend);
        for (net.minecraft.world.entity.Entity entity : this.selectEntities(serverWorld, this.getBlockAABB(locatableBlock.blockPosition()))) {
            Vec3 hitPosition;
            double sqdist;
            Optional vec3d = entity.getBoundingBox().clip(vec3din, vec3dend);
            if (!vec3d.isPresent() || !((sqdist = (hitPosition = (Vec3)vec3d.get()).distanceToSqr(vec3din)) < currentSqDist)) continue;
            currentSqDist = sqdist;
            returnedEntity = new SpongeRayTraceResult<Entity>((Entity)entity, VecHelper.toVector3d(hitPosition));
        }
        return Optional.ofNullable(returnedEntity);
    }

    @Override
    final boolean shouldCheckFailures() {
        return true;
    }
}

