/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config;

import java.util.Objects;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.SurfaceRule;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.common.accessor.world.level.levelgen.NoiseGeneratorSettingsAccessor;

public final class SpongeNoiseGeneratorConfig {

    public static final class FactoryImpl
    implements NoiseGeneratorConfig.Factory {
        @Override
        public NoiseGeneratorConfig amplified() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.AMPLIFIED);
        }

        @Override
        public NoiseGeneratorConfig overworld() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.OVERWORLD);
        }

        @Override
        public NoiseGeneratorConfig nether() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.NETHER);
        }

        @Override
        public NoiseGeneratorConfig end() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.END);
        }

        @Override
        public NoiseGeneratorConfig caves() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.CAVES);
        }

        @Override
        public NoiseGeneratorConfig floatingIslands() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.FLOATING_ISLANDS);
        }

        @Override
        public NoiseGeneratorConfig largeBiomes() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.LARGE_BIOMES);
        }
    }

    public static final class BuilderImpl
    implements NoiseGeneratorConfig.Builder {
        public NoiseConfig noiseConfig;
        public org.spongepowered.api.block.BlockState defaultBlock;
        public org.spongepowered.api.block.BlockState defaultFluid;
        public int seaLevel;
        public boolean aquifers;
        public boolean noiseCaves;
        public boolean oreVeins;
        public boolean noodleCaves;
        public boolean legacyRandomSource;
        public boolean disableMobGeneration;
        public SurfaceRule surfaceRule;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseGeneratorConfig.Builder noiseConfig(NoiseConfig config) {
            this.noiseConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder defaultBlock(org.spongepowered.api.block.BlockState block) {
            this.defaultBlock = Objects.requireNonNull(block, "block");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder defaultFluid(org.spongepowered.api.block.BlockState fluid) {
            this.defaultFluid = Objects.requireNonNull(fluid, "fluid");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder surfaceRule(SurfaceRule rule) {
            this.surfaceRule = rule;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder seaLevel(int y) {
            this.seaLevel = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder mobGeneration(boolean mobGeneration) {
            this.disableMobGeneration = !mobGeneration;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder aquifers(boolean enableAquifers) {
            this.aquifers = enableAquifers;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder noiseCaves(boolean enableNoiseCaves) {
            this.noiseCaves = enableNoiseCaves;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder oreVeins(boolean enableOreVeins) {
            this.oreVeins = enableOreVeins;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder noodleCaves(boolean noodleCaves) {
            this.noodleCaves = noodleCaves;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder randomSource(boolean useLegacyRandomSource) {
            this.legacyRandomSource = useLegacyRandomSource;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder reset() {
            this.noiseConfig = NoiseConfig.overworld();
            this.defaultBlock = (org.spongepowered.api.block.BlockState)BlockTypes.STONE.get().defaultState();
            this.defaultFluid = (org.spongepowered.api.block.BlockState)BlockTypes.WATER.get().defaultState();
            this.surfaceRule = SurfaceRule.overworld();
            this.seaLevel = 63;
            this.aquifers = false;
            this.noiseCaves = false;
            this.oreVeins = false;
            this.noodleCaves = false;
            this.legacyRandomSource = false;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder from(NoiseGeneratorConfig value) {
            this.noiseConfig = value.noiseConfig();
            this.defaultBlock = value.defaultBlock();
            this.defaultFluid = value.defaultFluid();
            this.surfaceRule = value.surfaceRule();
            this.seaLevel = value.seaLevel();
            this.aquifers = value.aquifers();
            this.noiseCaves = value.noiseCaves();
            this.noodleCaves = value.noodleCaves();
            this.legacyRandomSource = value.legacyRandomSource();
            return this;
        }

        public NoiseGeneratorConfig build() {
            NoiseGeneratorSettings settings = NoiseGeneratorSettingsAccessor.invoker$new(new StructureSettings(true), (NoiseSettings)this.noiseConfig, (BlockState)this.defaultBlock, (BlockState)this.defaultFluid, (SurfaceRules.RuleSource)this.surfaceRule, this.seaLevel, this.disableMobGeneration, this.aquifers, this.noiseCaves, this.oreVeins, this.noodleCaves, this.legacyRandomSource);
            return (NoiseGeneratorConfig)settings;
        }
    }
}

