/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import java.util.Objects;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.noise.SamplingConfig;
import org.spongepowered.api.world.generation.config.noise.Shaper;
import org.spongepowered.api.world.generation.config.noise.SlideConfig;

public final class SpongeNoiseConfig {
    private SpongeNoiseConfig() {
    }

    public static final class FactoryImpl
    implements NoiseConfig.Factory {
        @Override
        public NoiseConfig overworld() {
            return Holder.OVERWORLD;
        }

        @Override
        public NoiseConfig nether() {
            return Holder.NETHER;
        }

        @Override
        public NoiseConfig end() {
            return Holder.END;
        }

        private static final class Holder {
            private static final NoiseConfig OVERWORLD = (NoiseConfig)NoiseSettings.create((int)-64, (int)384, (NoiseSamplingSettings)new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), (NoiseSlider)new NoiseSlider(-0.078125, 2, 8), (NoiseSlider)new NoiseSlider(0.1171875, 3, 0), (int)1, (int)2, (boolean)false, (boolean)false, (boolean)false, (TerrainShaper)TerrainProvider.overworld((boolean)false));
            private static final NoiseConfig NETHER = (NoiseConfig)NoiseSettings.create((int)0, (int)128, (NoiseSamplingSettings)new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), (NoiseSlider)new NoiseSlider(0.9375, 3, 0), (NoiseSlider)new NoiseSlider(2.5, 4, -1), (int)1, (int)2, (boolean)false, (boolean)false, (boolean)false, (TerrainShaper)TerrainProvider.nether());
            private static final NoiseConfig END = (NoiseConfig)NoiseSettings.create((int)0, (int)128, (NoiseSamplingSettings)new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), (NoiseSlider)new NoiseSlider(-23.4375, 64, -46), (NoiseSlider)new NoiseSlider(-0.234375, 7, 1), (int)2, (int)1, (boolean)true, (boolean)false, (boolean)false, (TerrainShaper)TerrainProvider.end());

            private Holder() {
            }
        }
    }

    public static final class BuilderImpl
    implements NoiseConfig.Builder {
        public SamplingConfig sampling;
        public SlideConfig top;
        public SlideConfig bottom;
        public int minY;
        public int height;
        public int horizontalSize;
        public int verticalSize;
        public boolean largeBiomes;
        public boolean islandNoiseOverride;
        private Shaper terrainShaper;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseConfig.Builder minY(int minY) {
            this.minY = minY;
            return this;
        }

        @Override
        public NoiseConfig.Builder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        public NoiseConfig.Builder sampling(SamplingConfig sampling) {
            this.sampling = Objects.requireNonNull(sampling, "sampling");
            return this;
        }

        @Override
        public NoiseConfig.Builder top(SlideConfig top) {
            this.top = Objects.requireNonNull(top, "top");
            return this;
        }

        @Override
        public NoiseConfig.Builder bottom(SlideConfig bottom) {
            this.bottom = Objects.requireNonNull(bottom, "bottom");
            return this;
        }

        @Override
        public NoiseConfig.Builder horizontalSize(int horizontal) {
            this.horizontalSize = horizontal;
            return this;
        }

        @Override
        public NoiseConfig.Builder verticalSize(int vertical) {
            this.verticalSize = vertical;
            return this;
        }

        @Override
        public NoiseConfig.Builder islandNoiseOverride(boolean islandNoiseOverride) {
            this.islandNoiseOverride = islandNoiseOverride;
            return this;
        }

        @Override
        public NoiseConfig.Builder largeBiomes(boolean largeBiomes) {
            this.largeBiomes = largeBiomes;
            return this;
        }

        @Override
        public NoiseConfig.Builder terrainShaper(Shaper terrainShaper) {
            this.terrainShaper = terrainShaper;
            return this;
        }

        @Override
        public NoiseConfig.Builder reset() {
            this.minY = -64;
            this.height = 384;
            this.sampling = SamplingConfig.of(1.0, 80.0, 1.0, 160.0);
            this.top = SlideConfig.of(-0.078125, 2, 8);
            this.bottom = SlideConfig.of(0.1171875, 3, 0);
            this.horizontalSize = 1;
            this.verticalSize = 2;
            this.islandNoiseOverride = false;
            this.largeBiomes = false;
            this.terrainShaper = Shaper.overworld();
            return this;
        }

        @Override
        public NoiseConfig.Builder from(NoiseConfig value) {
            Objects.requireNonNull(value, "value");
            this.minY = value.minY();
            this.height = value.height();
            this.sampling = value.samplingConfig();
            this.top = value.topConfig();
            this.bottom = value.bottomConfig();
            this.horizontalSize = value.horizontalSize();
            this.verticalSize = value.verticalSize();
            this.islandNoiseOverride = value.islandNoiseOverride();
            this.largeBiomes = value.largeBiomes();
            this.terrainShaper = value.terrainShaper();
            return this;
        }

        public @NonNull NoiseConfig build() {
            Objects.requireNonNull(this.sampling, "sampling");
            Objects.requireNonNull(this.top, "top");
            Objects.requireNonNull(this.bottom, "bottom");
            return (NoiseConfig)NoiseSettings.create((int)this.minY, (int)this.height, (NoiseSamplingSettings)((NoiseSamplingSettings)this.sampling), (NoiseSlider)((NoiseSlider)this.top), (NoiseSlider)((NoiseSlider)this.bottom), (int)this.horizontalSize, (int)this.verticalSize, (boolean)this.islandNoiseOverride, (boolean)false, (boolean)this.largeBiomes, (TerrainShaper)((TerrainShaper)this.terrainShaper));
        }
    }
}

