/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.vanilla.client.gui.screen.PluginScreen;
import org.spongepowered.vanilla.client.gui.widget.ScrollPanel;
import org.spongepowered.vanilla.util.Bounds;

public final class MetadataPanel
extends ScrollPanel
implements NarratableEntry {
    private static final Component NO_RESULTS = new TextComponent("No data...").withStyle(ChatFormatting.GRAY);
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}://)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]+\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    static final int INDENT_SIZE = 12;
    private final Minecraft minecraft;
    private final PluginScreen screen;
    private final int lineHeight;
    private String activePluginName;
    private final List<Category> categories = new ObjectArrayList();
    private final List<Category> resizedCategories = new ObjectArrayList();
    private int maxKeyWidth;

    public MetadataPanel(Minecraft minecraft, PluginScreen screen, int width, int height, int top, int left) {
        super(minecraft, width, height, top, left);
        this.minecraft = minecraft;
        this.screen = screen;
        Objects.requireNonNull(this.minecraft.font);
        this.lineHeight = 9 + 1;
    }

    public void setMetadata(@Nullable PluginMetadata metadata) {
        this.categories.clear();
        this.maxKeyWidth = 0;
        if (metadata == null) {
            this.resizedCategories.clear();
            this.activePluginName = null;
            return;
        }
        this.activePluginName = metadata.name().orElse(metadata.id());
        this.categories.add(new Category("Details").addEntry(new Entry("ID", metadata.id())).addEntry(new Entry("Name", metadata.name().orElse(null))).addEntry(new Entry("Version", metadata.version().toString())).addEntry(new Entry("Entry", metadata.entrypoint())).addEntry(new Entry("Description", metadata.description().orElse(null))));
        this.categories.add(new Category("Contributors", metadata.contributors().stream().map(c -> new Entry(c.name(), c.description().orElse(""))).collect(Collectors.toList())));
        this.categories.add(new Category("Dependencies", metadata.dependencies().stream().map(d -> Lists.newArrayList((Object[])new Entry[]{new Entry(d.id(), ""), new Entry("Version", d.version().toString(), 1), new Entry("Optional", String.valueOf(d.optional()), 1), new Entry("Load Order", d.loadOrder().name(), 1)})).flatMap(Collection::stream).collect(Collectors.toList())));
        this.categories.add(new Category("Resources").addEntry(new Entry("Homepage", metadata.links().homepage().map(URL::toString).orElse(null))).addEntry(new Entry("Issues", metadata.links().issues().map(URL::toString).orElse(null))).addEntry(new Entry("Source", metadata.links().source().map(URL::toString).orElse(null))));
        this.categories.add(new Category("Other", metadata.properties().entrySet().stream().map(e -> new Entry((String)e.getKey(), e.getValue().toString())).collect(Collectors.toList())));
        this.categories.stream().flatMap(c -> c.getEntries().stream()).forEach(e -> {
            int width = e.key == null ? 0 : this.minecraft.font.width((FormattedText)e.key);
            this.maxKeyWidth = Math.max(this.maxKeyWidth, width + e.level * 12);
        });
        this.resizeContent();
    }

    private void resizeContent() {
        this.resizedCategories.clear();
        this.resizedCategories.addAll(this.categories);
        for (Category category : this.resizedCategories) {
            ArrayList<Entry> newEntries = new ArrayList<Entry>();
            for (Entry entry : category.getEntries()) {
                if (entry.rawValue == null) continue;
                int levelOffset = entry.level * 12;
                int baseX = 4;
                int keyX = 16 + levelOffset;
                int separatorX = keyX + this.maxKeyWidth + 4 - levelOffset;
                int valueX = separatorX + this.minecraft.font.width(":") + 4;
                int maxWidth = this.width - valueX - 8;
                if (maxWidth < 0) continue;
                List<String> lines = Arrays.asList(this.efficientWrapper(entry.rawValue, maxWidth).split("\n"));
                newEntries.add(new Entry(entry.rawKey, lines.get(0), entry.level, entry.rawValue));
                newEntries.addAll(lines.stream().skip(1L).map(l -> new Entry(null, (String)l, entry.level, entry.rawValue)).collect(Collectors.toList()));
            }
            category.setEntries(newEntries);
        }
    }

    private int getTotalLineCount() {
        int categoryCount = this.resizedCategories.size();
        int entryCount = 0;
        for (Category category : this.resizedCategories) {
            entryCount += category.getEntries().size();
        }
        return entryCount + categoryCount + categoryCount;
    }

    private List<Entry> getAllEntries() {
        ObjectArrayList entries = new ObjectArrayList();
        for (Category category : this.resizedCategories) {
            entries.addAll(category.entries);
        }
        return entries;
    }

    private String efficientWrapper(String value, int width) {
        ObjectArrayList lines = new ObjectArrayList();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String lineCandidate = builder.toString() + c;
            if (this.minecraft.font.width(lineCandidate) > width) {
                lines.add(builder.append("\n").toString());
                builder.delete(0, builder.length());
            }
            builder.append(c);
            if (i + 1 < value.length()) continue;
            lines.add(builder.toString());
        }
        return String.join((CharSequence)"", (Iterable<? extends CharSequence>)lines);
    }

    @Override
    public int getContentHeight() {
        int height = this.getTotalLineCount() * this.lineHeight;
        if (height < this.bottom - this.top - 8) {
            height = this.bottom - this.top - 8;
        }
        return height;
    }

    @Override
    protected int getScrollAmount() {
        return this.lineHeight * 3;
    }

    @Override
    protected void drawPanel(PoseStack stack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        int baseX = this.left + 4;
        if (this.resizedCategories.isEmpty()) {
            Font font = this.minecraft.font;
            int noResultsWidth = font.width((FormattedText)NO_RESULTS);
            font.draw(stack, NO_RESULTS, (float)this.width / 2.0f + (float)this.left - (float)noResultsWidth / 2.0f, (float)(this.top + 10), 0xFFFFFF);
            return;
        }
        for (Category category : this.resizedCategories) {
            if (category.getEntries().size() == 0) continue;
            this.minecraft.font.draw(stack, category.name, (float)baseX, (float)relativeY, 0xFFFFFF);
            relativeY += this.lineHeight;
            for (Entry entry : category.getEntries()) {
                if (entry.value == null) continue;
                int levelOffset = entry.level * 12;
                int keyX = baseX + 12 + levelOffset;
                int separatorX = keyX + this.maxKeyWidth + 4 - levelOffset;
                int valueX = separatorX + this.minecraft.font.width(":") + 4;
                if (entry.key != null) {
                    this.minecraft.font.draw(stack, entry.key, (float)keyX, (float)relativeY, 0xFFFFFF);
                    if (entry.rawValue != null && !entry.rawValue.isEmpty()) {
                        this.minecraft.font.draw(stack, ":", (float)separatorX, (float)relativeY, 0xFFFFFF);
                    }
                }
                this.minecraft.font.draw(stack, entry.value, (float)valueX, (float)relativeY, 0xFFFFFF);
                if (entry.value.getStyle().getClickEvent() != null) {
                    entry.valueBounds = new Bounds(valueX, relativeY + 1, valueX + this.minecraft.font.width((FormattedText)entry.value), relativeY + this.lineHeight);
                }
                relativeY += this.lineHeight;
            }
            relativeY += this.lineHeight;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Entry entry = this.getAllEntries().stream().filter(e -> e.valueBounds != null && e.valueBounds.isInBounds((int)mouseX, (int)mouseY)).findFirst().orElse(null);
        if (entry == null) {
            return false;
        }
        Component component = entry.value;
        if (component != null) {
            this.screen.handleComponentClicked(component.getStyle());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void drawBackground() {
    }

    public static Component newChatWithLinks(String string, boolean allowMissingHeader) {
        TextComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            TextComponent link;
            Object url;
            block12: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new TextComponent(part);
                    } else {
                        ichat.append(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new TextComponent((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block12;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new TextComponent((String)url);
                            continue;
                        }
                        ichat.append((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new TextComponent((String)url);
                        continue;
                    }
                    ichat.append((String)url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url);
            link.withStyle(style -> style.withClickEvent(click).withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
            ichat = ichat == null ? link : ichat.append((Component)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new TextComponent(end);
        } else if (end.length() > 0) {
            ichat.append(string.substring(lastEnd));
        }
        return ichat;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput elementOutput) {
        if (this.activePluginName != null) {
            elementOutput.add(NarratedElementType.TITLE, this.activePluginName);
        }
    }

    private static final class Category {
        protected final Component name;
        protected final String rawName;
        private final List<Entry> entries = new ArrayList<Entry>();

        public Category(String name) {
            this.name = new TextComponent(name).withStyle(s -> s.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)));
            this.rawName = name;
        }

        public Category(String name, List<Entry> entries) {
            this(name);
            this.entries.addAll(entries);
        }

        public Category addEntry(Entry entry) {
            this.entries.add(entry);
            return this;
        }

        public Category setEntries(List<Entry> entries) {
            this.entries.clear();
            this.entries.addAll(entries);
            return this;
        }

        public Category clearEntries() {
            this.entries.clear();
            return this;
        }

        public List<Entry> getEntries() {
            return Collections.unmodifiableList(this.entries);
        }
    }

    private static final class Entry {
        protected final int level;
        @Nullable
        protected final String rawKey;
        @Nullable
        protected final String rawValue;
        @Nullable
        protected Component key;
        @Nullable
        protected Component value;
        @Nullable
        protected Bounds valueBounds;

        public Entry(@Nullable String key, @Nullable String value) {
            this(key, value, 0, null);
        }

        public Entry(@Nullable String key, @Nullable String value, int level) {
            this(key, value, level, null);
        }

        public Entry(@Nullable String key, @Nullable String value, int level, @Nullable String originalValue) {
            if (key != null) {
                this.key = new TextComponent(key);
            }
            this.rawKey = key;
            if (value != null) {
                Component linkComponent;
                MutableComponent newValue = new TextComponent(value).withStyle(ChatFormatting.GRAY);
                if (originalValue != null && (linkComponent = MetadataPanel.newChatWithLinks(originalValue, false)).getStyle().getClickEvent() != null) {
                    newValue.withStyle(s -> linkComponent.getStyle().applyTo(s));
                }
                this.value = newValue;
            }
            this.rawValue = value;
            this.level = level;
        }
    }
}

