/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.TaggedLogger;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class Logger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final MessageFormatter formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final boolean MINIMUM_LEVEL_COVERS_TRACE = Logger.isCoveredByMinimumLevel(Level.TRACE);
    private static final boolean MINIMUM_LEVEL_COVERS_DEBUG = Logger.isCoveredByMinimumLevel(Level.DEBUG);
    private static final boolean MINIMUM_LEVEL_COVERS_INFO = Logger.isCoveredByMinimumLevel(Level.INFO);
    private static final boolean MINIMUM_LEVEL_COVERS_WARN = Logger.isCoveredByMinimumLevel(Level.WARN);
    private static final boolean MINIMUM_LEVEL_COVERS_ERROR = Logger.isCoveredByMinimumLevel(Level.ERROR);
    private static final TaggedLogger instance = new TaggedLogger(null);
    private static final ConcurrentMap<String, TaggedLogger> loggers = new ConcurrentHashMap<String, TaggedLogger>();

    private Logger() {
    }

    public static TaggedLogger tag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return instance;
        }
        TaggedLogger logger = (TaggedLogger)loggers.get(tag);
        if (logger == null) {
            logger = new TaggedLogger(tag);
            TaggedLogger existing = loggers.putIfAbsent(tag, logger);
            return existing == null ? logger : existing;
        }
        return logger;
    }

    public static boolean isTraceEnabled() {
        return MINIMUM_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }

    public static void trace(Object message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, message, (Object[])null);
        }
    }

    public static void trace(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, message, (Object[])null);
        }
    }

    public static void trace(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, formatter, (Object)message, arguments);
        }
    }

    public static void trace(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static void trace(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, null, (Object[])null);
        }
    }

    public static void trace(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, (Object)message, (Object[])null);
        }
    }

    public static void trace(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, message, (Object[])null);
        }
    }

    public static void trace(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, formatter, (Object)message, arguments);
        }
    }

    public static void trace(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static boolean isDebugEnabled() {
        return MINIMUM_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG);
    }

    public static void debug(Object message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, message, (Object[])null);
        }
    }

    public static void debug(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, message, (Object[])null);
        }
    }

    public static void debug(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, formatter, (Object)message, arguments);
        }
    }

    public static void debug(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static void debug(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, null, (Object[])null);
        }
    }

    public static void debug(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, (Object)message, (Object[])null);
        }
    }

    public static void debug(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, message, (Object[])null);
        }
    }

    public static void debug(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, formatter, (Object)message, arguments);
        }
    }

    public static void debug(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static boolean isInfoEnabled() {
        return MINIMUM_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO);
    }

    public static void info(Object message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, message, (Object[])null);
        }
    }

    public static void info(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, message, (Object[])null);
        }
    }

    public static void info(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, formatter, (Object)message, arguments);
        }
    }

    public static void info(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static void info(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, null, (Object[])null);
        }
    }

    public static void info(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, (Object)message, (Object[])null);
        }
    }

    public static void info(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, message, (Object[])null);
        }
    }

    public static void info(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, formatter, (Object)message, arguments);
        }
    }

    public static void info(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static boolean isWarnEnabled() {
        return MINIMUM_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN);
    }

    public static void warn(Object message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, message, (Object[])null);
        }
    }

    public static void warn(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, message, (Object[])null);
        }
    }

    public static void warn(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, formatter, (Object)message, arguments);
        }
    }

    public static void warn(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static void warn(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, null, (Object[])null);
        }
    }

    public static void warn(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, (Object)message, (Object[])null);
        }
    }

    public static void warn(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, message, (Object[])null);
        }
    }

    public static void warn(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, formatter, (Object)message, arguments);
        }
    }

    public static void warn(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static boolean isErrorEnabled() {
        return MINIMUM_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    public static void error(Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, message, (Object[])null);
        }
    }

    public static void error(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, message, (Object[])null);
        }
    }

    public static void error(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, formatter, (Object)message, arguments);
        }
    }

    public static void error(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, formatter, (Object)message, (Object[])arguments);
        }
    }

    public static void error(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, null, (Object[])null);
        }
    }

    public static void error(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, (Object)message, (Object[])null);
        }
    }

    public static void error(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, message, (Object[])null);
        }
    }

    public static void error(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, formatter, (Object)message, arguments);
        }
    }

    public static void error(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, formatter, (Object)message, (Object[])arguments);
        }
    }

    private static boolean isCoveredByMinimumLevel(Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }
}

