/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import java.util.function.Supplier;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Builder;
import org.spongepowered.api.util.CopyableBuilder;

public interface DataHolderBuilder<H extends DataHolder, B extends DataHolderBuilder<H, B>>
extends Builder<H, B>,
CopyableBuilder<H, B> {
    default public B add(Value<?> value) {
        return this.add(value.key(), value.get());
    }

    default public B add(Iterable<? extends Value<?>> values) {
        values.forEach(this::add);
        return (B)this;
    }

    default public B add(DataManipulator manipulator) {
        return this.add(manipulator.getValues());
    }

    default public B addFrom(DataHolder dataHolder) {
        return this.add(dataHolder.getValues());
    }

    public <V> B add(Key<? extends Value<V>> var1, V var2);

    default public <V> B add(Supplier<? extends Key<? extends Value<V>>> key, V value) {
        return this.add(key.get(), value);
    }

    @Override
    public B from(H var1);

    @Override
    public B reset();

    public static interface Immutable<H extends DataHolder.Immutable<H>, B extends Immutable<H, B>>
    extends DataHolderBuilder<H, B> {
    }

    public static interface Mutable<H extends DataHolder.Mutable, B extends Mutable<H, B>>
    extends DataHolderBuilder<H, B> {
    }
}

