/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.RegistryLayer;
import org.spongepowered.api.Client;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.plugin.DummyPluginContainer;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.event.lifecycle.AbstractRegisterRegistryEvent;
import org.spongepowered.common.event.lifecycle.AbstractRegisterRegistryValueEvent;
import org.spongepowered.common.event.lifecycle.RegisterBuilderEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterChannelEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterDataEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterFactoryEventImpl;
import org.spongepowered.common.event.manager.SpongeEventManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.registry.SpongeBuilderProvider;
import org.spongepowered.common.registry.SpongeFactoryProvider;
import org.spongepowered.common.registry.SpongeRegistries;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.service.SpongeServiceProvider;
import org.spongepowered.common.service.server.permission.SpongeContextCalculator;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeLifecycle
implements Lifecycle {
    private final Game game;
    private final Injector injector;

    @Inject
    public SpongeLifecycle(Game game, Injector injector) {
        this.game = game;
        this.injector = injector;
    }

    @Override
    public Injector platformInjector() {
        return this.injector;
    }

    @Override
    public void establishFactories() {
        ((SpongeFactoryProvider)this.game.factoryProvider()).registerDefaultFactories();
    }

    @Override
    public void establishBuilders() {
        ((SpongeBuilderProvider)this.game.builderProvider()).registerDefaultBuilders();
        ((SpongeDataManager)this.game.dataManager()).registerDefaultBuilders();
    }

    @Override
    public void callRegisterFactoryEvent() {
        this.game.eventManager().post(new RegisterFactoryEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    @Override
    public void callRegisterBuilderEvent() {
        this.game.eventManager().post(new RegisterBuilderEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    @Override
    public void establishEarlyGlobalRegistries() {
        SpongeRegistryHolder holder = (SpongeRegistryHolder)((Object)this.game);
        holder.setRootMinecraftRegistry(BuiltInRegistries.REGISTRY);
        SpongeRegistries.registerEarlyGlobalRegistries(holder);
    }

    @Override
    public void establishGlobalRegistries(RegistryAccess.Frozen registryAccess, RegistryLayer layer) {
        SpongeRegistryHolder holder = (SpongeRegistryHolder)((Object)this.game);
        switch (layer) {
            case DIMENSIONS: {
                SpongeRegistries.registerGlobalRegistriesDimensionLayer((SpongeRegistryHolder)((Object)this.game), registryAccess);
                this.game.eventManager().post(new AbstractRegisterRegistryEvent.GameScopedImpl(Cause.of(EventContext.empty(), this.game), this.game));
                holder.registryHolder().freezeSpongeRootRegistry();
                break;
            }
            case RELOADABLE: {
                this.game.eventManager().post(new AbstractRegisterRegistryValueEvent.GameScopedImpl(Cause.of(EventContext.empty(), this.game), this.game));
                holder.registryHolder().freezeSpongeDynamicRegistries();
            }
        }
    }

    @Override
    public void callRegisterDataEvent() {
        this.game.eventManager().post(new RegisterDataEventImpl(Cause.of(EventContext.empty(), Sponge.game()), Sponge.game(), (SpongeDataManager)this.game.dataManager()));
    }

    @Override
    public void establishDataProviders() {
        ((SpongeDataManager)this.game.dataManager()).registerDefaultProviders();
    }

    @Override
    public void establishDataKeyListeners() {
        ((SpongeDataManager)this.game.dataManager()).registerKeyListeners();
    }

    @Override
    public void callRegisterChannelEvent() {
        this.game.eventManager().post(new RegisterChannelEventImpl(Cause.of(EventContext.empty(), this.game), this.game, (SpongeChannelManager)this.game.channelManager()));
    }

    @Override
    public void establishGameServices() {
        ((SpongeServiceProvider)((Object)this.game.serviceProvider())).init();
    }

    @Override
    public void establishServerServices() {
        ((MinecraftServerBridge)((Object)this.game.server())).bridge$initServices(this.game, this.injector);
    }

    @Override
    public void establishServerFeatures() {
        Sponge.server().serviceProvider().contextService().registerContextCalculator(new SpongeContextCalculator());
        ((SpongeServer)this.game.server()).getUsernameCache().load();
    }

    @Override
    public void callConstructEvent() {
        for (PluginContainer plugin : this.filterInternalPlugins(this.game.pluginManager().plugins())) {
            ((SpongeEventManager)this.game.eventManager()).postToPlugin(SpongeEventFactory.createConstructPluginEvent(Cause.of(EventContext.empty(), this.game), this.game, plugin), plugin);
        }
    }

    @Override
    public void establishServerRegistries(Server server) {
        SpongeRegistries.registerServerRegistries(server);
        this.game.eventManager().post(new AbstractRegisterRegistryEvent.EngineScopedImpl<Server>(Cause.of(EventContext.empty(), this.game), this.game, server));
        this.game.eventManager().post(new AbstractRegisterRegistryValueEvent.EngineScopedImpl<Server>(Cause.of(EventContext.empty(), this.game), this.game, server));
    }

    @Override
    public void establishClientRegistries(Client client) {
        this.game.eventManager().post(new AbstractRegisterRegistryEvent.EngineScopedImpl<Client>(Cause.of(EventContext.empty(), this.game), this.game, client));
        this.game.eventManager().post(new AbstractRegisterRegistryValueEvent.EngineScopedImpl<Client>(Cause.of(EventContext.empty(), this.game), this.game, client));
    }

    @Override
    public void callStartingEngineEvent(Engine engine) {
        this.game.eventManager().post(SpongeEventFactory.createStartingEngineEvent(PhaseTracker.getCauseStackManager().currentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    @Override
    public void callStartedEngineEvent(Engine engine) {
        this.game.eventManager().post(SpongeEventFactory.createStartedEngineEvent(PhaseTracker.getCauseStackManager().currentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    @Override
    public void callLoadedGameEvent() {
        this.game.eventManager().post(SpongeEventFactory.createLoadedGameEvent(PhaseTracker.getCauseStackManager().currentCause(), this.game));
    }

    @Override
    public void callStoppingEngineEvent(Engine engine) {
        SpongeGameProfileManager profileManager;
        this.game.eventManager().post(SpongeEventFactory.createStoppingEngineEvent(PhaseTracker.getCauseStackManager().currentCause(), engine, this.game, TypeToken.get(engine.getClass())));
        if (engine instanceof SpongeServer && (profileManager = ((SpongeServer)engine).gameProfileManagerIfPresent()) != null) {
            profileManager.close();
        }
    }

    @Override
    public void callStoppedGameEvent() {
        this.game.eventManager().post(SpongeEventFactory.createStoppedGameEvent(PhaseTracker.getCauseStackManager().currentCause(), this.game));
        ((AsyncScheduler)this.game.asyncScheduler()).close();
    }

    private Collection<PluginContainer> filterInternalPlugins(Collection<PluginContainer> plugins) {
        return plugins.stream().filter(plugin -> !(plugin instanceof DummyPluginContainer)).collect(Collectors.toList());
    }
}

