/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.TreeLayout;
import org.spongepowered.api.advancement.TreeLayoutElement;

public final class SpongeTreeLayout
implements TreeLayout {
    private final AdvancementTree tree;

    public SpongeTreeLayout(AdvancementTree tree) {
        this.tree = tree;
    }

    @Override
    public AdvancementTree tree() {
        return this.tree;
    }

    @Override
    public Collection<TreeLayoutElement> elements() {
        ImmutableSet.Builder elements = ImmutableSet.builder();
        SpongeTreeLayout.collectElements(this.tree.rootAdvancement(), (ImmutableSet.Builder<TreeLayoutElement>)elements);
        return elements.build();
    }

    private static void collectElements(Advancement advancement, ImmutableSet.Builder<TreeLayoutElement> elements) {
        advancement.displayInfo().ifPresent(displayInfo -> elements.add((Object)((TreeLayoutElement)((Object)displayInfo))));
        advancement.children().forEach(child -> SpongeTreeLayout.collectElements(child, elements));
    }

    @Override
    public Optional<TreeLayoutElement> element(Advancement advancement) {
        Optional<AdvancementTree> tree = advancement.tree();
        if (!(tree.isPresent() && advancement.displayInfo().isPresent() && tree.get().equals(this.tree))) {
            return Optional.empty();
        }
        return SpongeTreeLayout.findElementInfo(this.tree.rootAdvancement(), advancement.key()).map(TreeLayoutElement.class::cast);
    }

    private static Optional<DisplayInfo> findElementInfo(Advancement advancement, ResourceKey key) {
        if (advancement.key().equals(key)) {
            return advancement.displayInfo();
        }
        for (Advancement child : advancement.children()) {
            Optional<DisplayInfo> info = SpongeTreeLayout.findElementInfo(child, key);
            if (!info.isPresent()) continue;
            return info;
        }
        return Optional.empty();
    }
}

