/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class VanillaBossBarListener
implements BossBar.Listener {
    private final ServerBossEvent vanilla;

    public VanillaBossBarListener(ServerBossEvent vanilla) {
        this.vanilla = vanilla;
    }

    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        this.sendPacket(ClientboundBossEventPacket::createUpdateNamePacket);
    }

    public void bossBarProgressChanged(@NonNull BossBar bar, float oldProgress, float newProgress) {
        this.sendPacket(ClientboundBossEventPacket::createUpdateProgressPacket);
    }

    public void bossBarColorChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color newColor) {
        this.sendPacket(ClientboundBossEventPacket::createUpdateStylePacket);
    }

    public void bossBarOverlayChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay newOverlay) {
        this.sendPacket(ClientboundBossEventPacket::createUpdateStylePacket);
    }

    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsAdded, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsRemoved) {
        this.sendPacket(ClientboundBossEventPacket::createUpdatePropertiesPacket);
    }

    private void sendPacket(Function<BossEvent, ClientboundBossEventPacket> action) {
        ClientboundBossEventPacket packet = action.apply((BossEvent)this.vanilla);
        for (ServerPlayer player : this.vanilla.getPlayers()) {
            player.connection.send((Packet)packet);
        }
    }
}

