/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.common;

import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.applaunch.config.common.EigenRedstoneCategory;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class OptimizationCategory {
    @Setting(value="drops-pre-merge")
    @Comment(value="If 'true', block item drops are pre-processed to avoid \nhaving to spawn extra entities that will be merged post spawning. \nUsually, Sponge is smart enough to determine when to attempt an item pre-merge \nand when not to, however, in certain cases, some mods rely on items not being \npre-merged and actually spawned, in which case, the items will flow right through \nwithout being merged.")
    public boolean dropsPreMerge;
    @Setting(value="cache-tameable-owners")
    @Comment(value="Caches tameable entities owners to avoid constant lookups against data watchers. If mods \ncause issues, disable this.")
    public boolean cacheTameableOwners = true;
    @Setting(value="eigen-redstone")
    @Comment(value="Uses theosib's redstone algorithms to completely overhaul the way redstone works.")
    public final EigenRedstoneCategory eigenRedstone = new EigenRedstoneCategory();
    @Setting(value="bell-leak-fix")
    @Comment(value="Bells will store references of nearby entities when rang.\nThe entity list is never cleared, thus leaking memory until\nthe chunk is unloaded. Since the entity list is reused if the\nbell is rang again within 60 ticks, this provides an option to\nclear the list if it is not needed anymore.")
    public boolean bellLeak = true;
    @Setting(value="faster-thread-checks")
    @Comment(value="If 'true', allows for Sponge to make better assumptions on single threaded\noperations with relation to various checks for server threaded operations.\nThis is default to true due to Sponge being able to precisely inject when\nthe server thread is available. This should make an already fast operation\nmuch faster for better thread checks to ensure stability of sponge's systems.")
    public boolean fasterThreadChecks = true;
    @Setting(value="optimize-maps")
    @Comment(value="If 'true', re-writes the incredibly inefficient Vanilla Map code.\nThis yields enormous performance enhancements when using many maps, but has a tiny chance of breaking mods that modify Vanilla.It is strongly recommended to keep this on, unless explicitly advised otherwise by a Sponge developer")
    public boolean optimizeMaps = true;
    @Setting(value="optimize-hoppers")
    @Comment(value="Based on Aikar's optimization of Hoppers, setting this to 'true'\nwill allow for hoppers to save performing server -> client updates\nwhen transferring items. Because hoppers can transfer items multiple\ntimes per tick, these updates can get costly on the server, with\nlittle to no benefit to the client. Because of the nature of the\nchange, the default will be 'false' due to the inability to pre-emptively\nforetell whether mod compatibility will fail with these changes or not.\nRefer to: https://github.com/PaperMC/Paper/blob/8175ec916f31dcd130fe0884fe46bdc187d829aa/Spigot-Server-Patches/0269-Optimize-Hoppers.patch\nfor more details.")
    public boolean optimizeHoppers = false;
    @Setting(value="optimize-block-entity-ticking")
    @Comment(value="Based on Paper's TileEntity Ticking optimization\nsetting this to 'true' prevents unnecessary ticking in Chests and EnderChests\nSee https://github.com/PaperMC/Paper/blob/bb4002d82e355f033906fc894cc2320f665ba72d/Spigot-Server-Patches/0022-Optimize-TileEntity-Ticking.patch")
    public boolean optimizeBlockEntityTicking = true;
    @Setting(value="use-active-chunks-for-collisions")
    @Comment(value="Vanilla performs a lot of is area loaded checks during\nentity collision calculations with blocks, and because\nthese calculations require fetching the chunks to see\nif they are loaded, before getting the block states\nfrom those chunks, there can be some small performance\nincrease by checking the entity's owned active chunk\nit may currently reside in. Essentially, instead of\nasking the world if those chunks are loaded, the entity\nwould know whether it's chunks are loaded and that neighbor's\nchunks are loaded.")
    public boolean useActiveChunksForCollisions = false;
    @Setting(value="disable-failing-deserialization-log-spam")
    @Comment(value="Occasionally, some built in advancements, \nrecipes, etc. can fail to deserialize properly\nwhich ends up potentially spamming the server log\nand the original provider of the failing content\nis not able to fix. This provides an option to\nsuppress the exceptions printing out in the log.")
    public boolean disableFailingDeserializationLogSpam = true;
    @Setting(value="disable-scheduled-updates-for-persistent-leaf-blocks")
    @Comment(value="Leaf blocks placed by players will normally schedule\nupdates for themselves after placement, and on neighboring\nplacement. This optimization is relatively small but effectively\ndisables scheduling updates and reactive updates to leaves that\nare `persistent`. Does not drastically improve performance.")
    public boolean disableScheduledUpdatesForPersistentLeafBlocks = true;
    @Setting(value="enable-lazydfu")
    @Comment(value="By default, Vanilla 'warms-up' all migration rules for\nevery Minecraft version when the game starts. This often\ncauses a period of extremely high CPU usage when the game\nstarts, often for no benefit since the typical pattern is\nthat most chunks do not have to be migrated, or only have\nto be migrated from just a few versions. This option disables\nmigration rules from being 'warmed-up' and instead forces them\nto be generated on demand. This is a very safe optimization and\nshould usually remain enabled.")
    public boolean enableLazyDFU = true;

    public OptimizationCategory() {
        this.dropsPreMerge = AppLaunch.pluginPlatform().vanilla();
    }
}

