/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;

public final class NumericalParticleType
implements ParticleType {
    private final int id;
    private final Map<ParticleOption<?>, Object> defaultOptions;
    private final @Nullable DataCalculator dataCalculator;

    public NumericalParticleType(int id, Map<ParticleOption<?>, Object> defaultOptions, @Nullable DataCalculator dataCalculator) {
        this.id = id;
        this.defaultOptions = ImmutableMap.copyOf(defaultOptions);
        this.dataCalculator = dataCalculator;
    }

    public NumericalParticleType(int id) {
        this.id = id;
        this.defaultOptions = ImmutableMap.of();
        this.dataCalculator = null;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public <V> Optional<V> defaultOption(ParticleOption<V> option) {
        return Optional.ofNullable(this.defaultOptions.get(option));
    }

    @Override
    public Map<ParticleOption<?>, Object> defaultOptions() {
        return this.defaultOptions;
    }

    public int getData(ParticleEffect effect) {
        if (this.dataCalculator == null) {
            return 0;
        }
        return this.dataCalculator.getData(effect);
    }

    public static interface DataCalculator {
        public int getData(ParticleEffect var1);
    }
}

