/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.manager;

import com.google.common.base.CaseFormat;
import io.leangen.geantyref.GenericTypeReflector;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.configurate.util.Types;

public final class ListenerChecker {
    private static final boolean ALL_TRUE = Boolean.parseBoolean(System.getProperty("sponge.shouldFireAll", "").toLowerCase());
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("sponge.debugShouldFire", "").toLowerCase());
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<?> clazz;
    private Map<String, FieldData> fields = new HashMap<String, FieldData>();
    private Map<Class<?>, FieldData> fieldClassMap = new IdentityHashMap();

    private static String getName(Class<?> clazz) {
        String name = clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1).replace("$", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
    }

    public ListenerChecker(Class<?> clazz) {
        this.clazz = clazz;
        for (Field field : this.clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                FieldData data = new FieldData(field);
                this.fieldClassMap.put(this.getClassForField(field), data);
                this.fields.put(field.getName(), data);
                if (!ALL_TRUE) continue;
                if (DEBUG) {
                    LOGGER.debug("Forcing field {} to true!", (Object)field.getName());
                }
                try {
                    field.set(null, true);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Error setting field {} to true", (Object)field.getName(), (Object)e);
                }
                continue;
            }
            throw new IllegalStateException(String.format("ShouldFire field %s must be public and static!", field));
        }
    }

    public <T> void registerListenerFor(Class<T> eventClass) {
        this.updateFields(eventClass, true);
    }

    public <T> void unregisterListenerFor(Class<T> eventClass) {
        this.updateFields(eventClass, false);
    }

    private Class<?> getClassForField(Field field) {
        Method[] methods;
        String name = field.getName();
        for (Method eventMethod : methods = SpongeEventFactory.class.getMethods()) {
            Class possibleType = Types.allSuperTypesAndInterfaces(eventMethod.getGenericReturnType()).map(GenericTypeReflector::erase).filter(eventType -> {
                String eventMethodName = ListenerChecker.getName(eventType);
                return name.equals(eventMethodName);
            }).findFirst().orElse(null);
            if (possibleType == null) continue;
            return possibleType;
        }
        throw new IllegalStateException(String.format("ShouldFire field %s does not correspond to any SpongeAPI event! Check that the field is written in UPPER_CASE_UNDERSCORE format.", field));
    }

    public <T> void updateFields(Class<? super T> eventClass, boolean registering) {
        if (ALL_TRUE) {
            return;
        }
        Set superTypes = (Set)Types.allSuperTypesAndInterfaces(eventClass).map(t -> GenericTypeReflector.erase(t)).filter(c -> c != eventClass).collect(Collectors.toCollection(ReferenceOpenHashSet::new));
        for (Map.Entry<Class<?>, FieldData> entry : this.fieldClassMap.entrySet()) {
            if (!eventClass.isAssignableFrom(entry.getKey()) && !superTypes.contains(entry.getKey())) continue;
            entry.getValue().update(registering);
        }
    }

    private static class FieldData {
        Field field;
        int listenerCount = 0;

        FieldData(Field field) {
            this.field = field;
        }

        void update(boolean increment) {
            boolean val;
            this.listenerCount = increment ? ++this.listenerCount : --this.listenerCount;
            if (this.listenerCount < 0) {
                LOGGER.error("Decremented listener count to {} for field {}", (Object)this.listenerCount, (Object)this.field, (Object)new Exception("Dummy exception"));
            }
            boolean bl = val = this.listenerCount > 0;
            if (DEBUG) {
                LOGGER.debug("Updating field {} with value {}", (Object)this.field, (Object)val);
            }
            try {
                this.field.set(null, val);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Error setting field {} to {}", (Object)this.field, (Object)val, (Object)e);
            }
        }
    }
}

