/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.effect.BroadcastInventoryChangesEffect;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;
import org.spongepowered.common.util.PrettyPrinter;

public class CommandPhaseContext
extends GeneralPhaseContext<CommandPhaseContext> {
    @Nullable String command;
    @Nullable CommandMapping commandMapping;

    CommandPhaseContext(IPhaseState<CommandPhaseContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    @Override
    public boolean hasCaptures() {
        return super.hasCaptures();
    }

    @Override
    protected void reset() {
        super.reset();
        this.command = null;
        this.commandMapping = null;
    }

    public CommandPhaseContext command(String command) {
        this.command = command;
        return this;
    }

    public CommandPhaseContext commandMapping(CommandMapping mapping) {
        this.commandMapping = mapping;
        return this;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "Command", this.command == null ? "empty command" : this.command).add(s + "- %s: %s", "Command Mapping", this.commandMapping == null ? "no mapping" : this.commandMapping.toString());
        return printer;
    }

    @Override
    public void close() {
        if (this.getSource() instanceof ServerPlayer) {
            TransactionalCaptureSupplier transactor = this.getTransactor();
            transactor.logPlayerInventoryChange((Player)((ServerPlayer)this.getSource()), PlayerInventoryTransaction.EventCreator.STANDARD);
            try (EffectTransactor ignored = BroadcastInventoryChangesEffect.transact(transactor);){
                ((ServerPlayer)this.getSource()).containerMenu.broadcastChanges();
            }
        }
        super.close();
    }
}

