/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.world.BlockChange;

final class CommandState
extends GeneralState<CommandPhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> COMMAND_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.commandMapping != null) {
            frame.pushCause(ctx.commandMapping);
        }
    });

    CommandState() {
    }

    @Override
    public CommandPhaseContext createNewContext(PhaseTracker tracker) {
        return new CommandPhaseContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> getFrameModifier() {
        return this.COMMAND_MODIFIER;
    }

    @Override
    public void postBlockTransactionApplication(CommandPhaseContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        PhaseTracker.getCauseStackManager().currentCause().first(org.spongepowered.api.entity.living.player.Player.class).ifPresent(user -> TrackingUtil.associateTrackerToTarget(blockChange, transaction, user.uniqueId()));
    }

    @Override
    public void associateNeighborStateNotifier(CommandPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerLevel minecraftWorld, PlayerTracker.Type notifier) {
        context.getSource(org.spongepowered.api.entity.living.player.Player.class).ifPresent(player -> ((LevelChunkBridge)minecraftWorld.getChunkAt(notifyPos)).bridge$addTrackedBlockPosition(block, notifyPos, player.uniqueId(), PlayerTracker.Type.NOTIFIER));
    }

    @Override
    public void unwind(CommandPhaseContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(CommandPhaseContext context) {
        Optional<Player> playerSource = context.getSource(Player.class);
        if (playerSource.isPresent()) {
            return () -> (ResourceKey)((Player)playerSource.get()).level.dimension().location();
        }
        return super.attemptWorldKey(context);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(CommandPhaseContext context, Entity entityToSpawn) {
        return SpawnTypes.PLACEMENT;
    }
}

