/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingGridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.PrimaryPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.BrewingStandInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.LargeChestInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleGridLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleIndexedLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.BasicSlotLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.util.ContainerUtil;

public class LensRegistrar {
    private static Map<Class<?>, Int2ObjectMap<Lens>> lenses = new HashMap();
    private static Map<Class<?>, LensFactory> lensFactories = new HashMap();

    private static Lens lensSlot(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return slotLensProvider.getSlotLens(0);
    }

    public static void register(LensFactory lensFactory, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            lensFactories.put(clazz, lensFactory);
        }
    }

    public static LensFactory restricted(LensFactory original, Predicate<Integer> sizeRestriction) {
        return (inventory, size, slotLensProvider) -> {
            if (sizeRestriction.test(size)) {
                return original.apply(inventory, size, slotLensProvider);
            }
            return null;
        };
    }

    public static Lens getLens(Object inventory, SlotLensProvider slotLensProvider, int size) {
        return (Lens)LensRegistrar.getLenses(inventory.getClass()).computeIfAbsent(size, k -> LensRegistrar.generateLens(inventory, size, slotLensProvider));
    }

    private static Int2ObjectMap<Lens> getLenses(Class<?> inventory) {
        return lenses.computeIfAbsent(inventory, k -> new Int2ObjectOpenHashMap());
    }

    private static Lens generateLens(Object inventory, int size, SlotLensProvider slotLensProvider) {
        if (size == 0) {
            return new DefaultEmptyLens();
        }
        LensFactory lensFactory = lensFactories.get(inventory.getClass());
        Lens lens = null;
        if (lensFactory != null && (lens = lensFactory.apply(inventory.getClass(), size, slotLensProvider)) != null) {
            return lens;
        }
        if (inventory instanceof CraftingContainer) {
            lens = LensRegistrar.lensCraftingInventory(size, ((CraftingContainer)inventory).getWidth(), ((CraftingContainer)inventory).getHeight(), slotLensProvider);
        } else if (inventory instanceof AbstractContainerMenu) {
            lens = ContainerUtil.generateLens((AbstractContainerMenu)inventory, slotLensProvider);
        } else if (size == 1) {
            return slotLensProvider.getSlotLens(0);
        }
        if (lens != null) {
            return lens;
        }
        return new SingleIndexedLens(0, size, inventory.getClass(), slotLensProvider);
    }

    private static @Nullable Lens lensCraftingInventory(int size, int width, int height, SlotLensProvider slotLensProvider) {
        if (size != width * height) {
            return null;
        }
        return new CraftingGridInventoryLens(0, width, height, slotLensProvider);
    }

    private static @Nullable Lens lensGrid(Object inventory, int size, int width, int height, SlotLensProvider slotLensProvider) {
        if (size != width * height) {
            return null;
        }
        return new SingleGridLens(0, width, height, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensBrewingStandTileEntity(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new BrewingStandInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensFurnace(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new FurnaceInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensDoubleSided(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new LargeChestInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensRepairContainer(Object inventory, int size, SlotLensProvider slotLensProvider) {
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        lenses.add(new DefaultIndexedLens(0, 3, slotLensProvider));
        lenses.add(new PrimaryPlayerInventoryLens(3, slotLensProvider, true));
        return new ContainerLens(size, inventory.getClass(), slotLensProvider, lenses);
    }

    private static Lens lensWorkbenchContainer(Object inventory, int size, SlotLensProvider slotLensProvider) {
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        lenses.add(new CraftingInventoryLens(0, 1, 3, 3, slotLensProvider));
        lenses.add(new PrimaryPlayerInventoryLens(10, slotLensProvider, true));
        return new ContainerLens(size, inventory.getClass(), slotLensProvider, lenses);
    }

    private static Lens lensPlayerContainer(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new ContainerPlayerInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    static {
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensGrid(inv, size, 9, 3, slp), ChestBlockEntity.class, ShulkerBoxBlockEntity.class, TrappedChestBlockEntity.class, BarrelBlockEntity.class, PlayerEnderChestContainer.class, MinecartChest.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensGrid(inv, size, 3, 3, slp), DispenserBlockEntity.class, DropperBlockEntity.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensCraftingInventory(size, 2, 2, slp), CraftingContainer.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensCraftingInventory(size, 3, 3, slp), CraftingContainer.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensGrid(inv, size, 5, 1, slp), HopperBlockEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensFurnace, s -> s == 3), AbstractFurnaceBlockEntity.class, SmokerBlockEntity.class, FurnaceBlockEntity.class, BlastFurnaceBlockEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensBrewingStandTileEntity, s -> s == 5), BrewingStandBlockEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensDoubleSided, s -> s == 54), CompoundContainer.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensRepairContainer, s -> s == 30), AnvilMenu.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensWorkbenchContainer, s -> s == 37), CraftingMenu.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensPlayerContainer, s -> s == 46), InventoryMenu.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::generateLens, s -> s == 8), AbstractVillager.class, Villager.class, WanderingTrader.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensSlot, s -> s == 1), ResultContainer.class);
    }

    private static interface LensFactory {
        public @Nullable Lens apply(Object var1, int var2, SlotLensProvider var3);
    }

    public static class BasicSlotLensProvider
    implements SlotLensProvider {
        private static Map<Integer, BasicSlotLens> basicSlotLenses = new ConcurrentHashMap<Integer, BasicSlotLens>();
        public final int base;
        public final int size;

        public BasicSlotLensProvider(int size) {
            this(0, size);
        }

        public BasicSlotLensProvider(int base, int size) {
            this.base = base;
            this.size = size;
        }

        @Override
        public SlotLens getSlotLens(int index) {
            return basicSlotLenses.computeIfAbsent(index, BasicSlotLens::new);
        }

        public String toString() {
            return "SlotLensProvider[base=" + this.base + "][size=" + this.size + "]";
        }
    }
}

