/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.level.entity.LevelEntityGetter;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.client.ClientPlayer;
import org.spongepowered.api.world.client.ClientLocation;
import org.spongepowered.api.world.client.ClientWorld;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.mixin.api.minecraft.world.level.LevelMixin_API;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin_API
extends LevelMixin_API<ClientWorld, ClientLocation>
implements ClientWorld {
    @Shadow
    @Final
    List<AbstractClientPlayer> players;

    @Shadow
    protected abstract LevelEntityGetter<net.minecraft.world.entity.Entity> shadow$getEntities();

    @Override
    public boolean isLoaded() {
        return Minecraft.getInstance().level == this;
    }

    @Override
    public ChunkLayout chunkLayout() {
        if (this.api$chunkLayout == null) {
            int height = ((ClientLevel)this).getHeight();
            int min = ((ClientLevel)this).getMinBuildHeight();
            this.api$chunkLayout = new SpongeChunkLayout(min, height);
        }
        return this.api$chunkLayout;
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        return Optional.ofNullable((net.minecraft.world.entity.Entity)this.shadow$getEntities().get(uuid));
    }

    public Collection<Entity> entities() {
        return (Collection)ImmutableList.copyOf((Iterable)this.shadow$getEntities().getAll());
    }

    @Override
    public Collection<? extends ClientPlayer> players() {
        return new ArrayList<AbstractClientPlayer>(this.players);
    }
}

