/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.chat.ChatVisibility;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.living.player.KickPlayerEvent;
import org.spongepowered.api.event.entity.living.player.PlayerChangeClientSettingsEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.locale.Locales;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.ConnectionAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.bridge.world.BossEventBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.type.SpongeSkinPart;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.mixin.core.world.entity.player.PlayerMixin;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.border.PlayerOwnBorderListener;
import org.spongepowered.common.world.portal.PortalLogic;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.server.level.ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin
implements SubjectBridge,
ServerPlayerBridge {
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Shadow
    @Final
    public ServerPlayerGameMode gameMode;
    @Shadow
    @Final
    public MinecraftServer server;
    @Shadow
    private int lastRecordedExperience;
    @Shadow
    private boolean isChangingDimension;
    @Shadow
    public boolean wonGame;
    @Shadow
    private boolean seenCredits;
    @Shadow
    private Vec3 enteredNetherPosition;
    @Shadow
    private int lastSentExp;
    @Shadow
    private float lastSentHealth;
    @Shadow
    private int lastSentFood;
    private @Nullable net.minecraft.network.chat.Component impl$connectionMessage;
    private Locale impl$language = Locales.DEFAULT;
    private org.spongepowered.api.scoreboard.Scoreboard impl$scoreboard = Sponge.game().server().serverScoreboard().get();
    private @Nullable Boolean impl$keepInventory = null;
    private int impl$viewDistance;
    private int impl$skinPartMask;
    private Set<SkinPart> impl$skinParts = ImmutableSet.of();
    private final PlayerOwnBorderListener impl$borderListener = new PlayerOwnBorderListener((net.minecraft.server.level.ServerPlayer)this);
    private boolean impl$sleepingIgnored;

    @Shadow
    public abstract ServerLevel shadow$getLevel();

    @Shadow
    public abstract void shadow$setCamera(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract void shadow$stopRiding();

    @Shadow
    public abstract void shadow$closeContainer();

    @Shadow
    public abstract void shadow$resetStat(Stat<?> var1);

    @Shadow
    protected abstract void shadow$tellNeutralMobsThatIDied();

    @Shadow
    protected abstract void shadow$createEndPlatform(ServerLevel var1, BlockPos var2);

    @Shadow
    protected abstract void shadow$triggerDimensionChangeTriggers(ServerLevel var1);

    @Shadow
    public abstract void shadow$doCloseContainer();

    @Shadow
    public abstract void shadow$setLevel(ServerLevel var1);

    @Override
    public @Nullable net.minecraft.network.chat.Component bridge$getConnectionMessageToSend() {
        if (this.impl$connectionMessage == null) {
            return net.minecraft.network.chat.Component.literal((String)"");
        }
        return this.impl$connectionMessage;
    }

    @Override
    public void bridge$setConnectionMessageToSend(net.minecraft.network.chat.Component message) {
        this.impl$connectionMessage = message;
    }

    @Override
    public String bridge$getSubjectCollectionIdentifier() {
        return "user";
    }

    @Override
    public Tristate bridge$permDefault(String permission) {
        return Tristate.FALSE;
    }

    @Override
    protected final boolean impl$setLocation(boolean isChangeOfWorld, ServerLevel originalDestination, ServerLevel destinationWorld, Vector3d destinationPosition) {
        if (this.shadow$isRemoved()) {
            return false;
        }
        net.minecraft.server.level.ServerPlayer player = (net.minecraft.server.level.ServerPlayer)this;
        player.stopRiding();
        if (player.isSleeping()) {
            player.stopSleepInBed(true, true);
        }
        ChunkPos chunkPos = VecHelper.toChunkPos(Sponge.server().chunkLayout().forceToChunk(destinationPosition.toInt()));
        destinationWorld.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkPos, 1, (Object)player.getId());
        if (isChangeOfWorld) {
            this.shadow$absMoveTo(destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), this.shadow$getYRot(), this.shadow$getXRot());
            EntityUtil.performPostChangePlayerWorldLogic(player, this.shadow$getLevel(), destinationWorld, destinationWorld, false);
        } else {
            this.connection.teleport(destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), this.shadow$getYRot(), this.shadow$getXRot(), new HashSet());
            this.connection.resetPosition();
        }
        return true;
    }

    @Override
    public void bridge$refreshExp() {
        this.lastRecordedExperience = -1;
    }

    @Override
    public boolean bridge$kick(Component message) {
        Component messageToSend;
        if (ShouldFire.KICK_PLAYER_EVENT) {
            KickPlayerEvent kickEvent = SpongeEventFactory.createKickPlayerEvent(PhaseTracker.getCauseStackManager().currentCause(), message, message, (ServerPlayer)((Object)this));
            if (Sponge.eventManager().post(kickEvent)) {
                return false;
            }
            messageToSend = kickEvent.message();
        } else {
            messageToSend = message;
        }
        net.minecraft.network.chat.Component component = SpongeAdventure.asVanilla(messageToSend);
        this.connection.disconnect(component);
        return true;
    }

    @Override
    public Locale bridge$getLanguage() {
        return this.impl$language;
    }

    @Override
    public void bridge$setLanguage(Locale language) {
        this.impl$language = language;
        if (this.connection != null) {
            Channel channel = ((ConnectionAccessor)this.connection.connection).accessor$channel();
            channel.attr(SpongeAdventure.CHANNEL_LOCALE).set((Object)language);
            SpongeAdventure.forEachBossBar(bar -> {
                if (bar.getPlayers().contains(this)) {
                    this.connection.send((Packet)ClientboundBossEventPacket.createUpdateNamePacket((BossEvent)bar));
                }
            });
            this.containerMenu.broadcastFullState();
        }
    }

    @Override
    public void bridge$initScoreboard() {
        ((ServerScoreboardBridge)this.shadow$getScoreboard()).bridge$addPlayer((net.minecraft.server.level.ServerPlayer)this, true);
    }

    @Override
    public void bridge$removeScoreboardOnRespawn() {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)((Object)this)).scoreboard())).bridge$removePlayer((net.minecraft.server.level.ServerPlayer)this, false);
    }

    @Override
    public void bridge$setScoreboardOnRespawn(org.spongepowered.api.scoreboard.Scoreboard scoreboard) {
        this.impl$scoreboard = scoreboard;
        ((ServerScoreboardBridge)((Object)((ServerPlayer)((Object)this)).scoreboard())).bridge$addPlayer((net.minecraft.server.level.ServerPlayer)this, false);
    }

    @Override
    public org.spongepowered.api.scoreboard.Scoreboard bridge$getScoreboard() {
        return this.impl$scoreboard;
    }

    @Override
    public void bridge$replaceScoreboard(@Nullable org.spongepowered.api.scoreboard.Scoreboard scoreboard) {
        if (scoreboard == null) {
            scoreboard = Sponge.game().server().serverScoreboard().orElseThrow(() -> new IllegalStateException("Server does not have a valid scoreboard"));
        }
        this.impl$scoreboard = scoreboard;
    }

    @Override
    public boolean bridge$keepInventory() {
        if (this.impl$keepInventory == null) {
            return this.level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        }
        return this.impl$keepInventory;
    }

    @Override
    public int bridge$getExperiencePointsOnDeath(LivingEntity entity) {
        if (this.impl$keepInventory != null && this.impl$keepInventory.booleanValue()) {
            return 0;
        }
        return super.bridge$getExperiencePointsOnDeath(entity);
    }

    @Override
    public int bridge$getViewDistance() {
        return this.impl$viewDistance;
    }

    @Override
    public Set<SkinPart> bridge$getSkinParts() {
        byte mask = (Byte)this.shadow$getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION);
        if (this.impl$skinPartMask != mask) {
            this.impl$skinParts = (Set)Sponge.game().registry(RegistryTypes.SKIN_PART).stream().map(part -> (SpongeSkinPart)part).filter(part -> part.test(mask)).collect(ImmutableSet.toImmutableSet());
            this.impl$skinPartMask = mask;
        }
        return this.impl$skinParts;
    }

    @Override
    public void bridge$setSkinParts(Set<SkinPart> skinParts) {
        int mask = 0;
        for (SkinPart part : skinParts) {
            mask |= ((SpongeSkinPart)part).getMask();
        }
        this.shadow$getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)((byte)mask));
        this.impl$skinParts = ImmutableSet.copyOf(skinParts);
        this.impl$skinPartMask = mask;
    }

    @Override
    public boolean bridge$sleepingIgnored() {
        return this.impl$sleepingIgnored;
    }

    @Override
    public void bridge$setSleepingIgnored(boolean sleepingIgnored) {
        this.impl$sleepingIgnored = sleepingIgnored;
    }

    @Overwrite
    public void teleportTo(ServerLevel world, double x, double y, double z, float yaw, float pitch) {
        net.minecraft.server.level.ServerPlayer player = (net.minecraft.server.level.ServerPlayer)this;
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        double actualYaw = yaw;
        double actualPitch = pitch;
        boolean hasMovementContext = PhaseTracker.getCauseStackManager().currentContext().containsKey(EventContextKeys.MOVEMENT_TYPE);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (!hasMovementContext) {
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            }
            if (world == player.level) {
                @Nullable Vector3d destination = this.impl$fireMoveEvent(PhaseTracker.SERVER, new Vector3d(x, y, z));
                if (destination == null) {
                    return;
                }
                actualX = destination.x();
                actualY = destination.y();
                actualZ = destination.z();
                if (ShouldFire.ROTATE_ENTITY_EVENT) {
                    RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.currentCause(), (Entity)player, new Vector3d(actualPitch, actualYaw, 0.0), new Vector3d(pitch, yaw, 0.0f));
                    SpongeCommon.post(rotateEvent);
                    actualYaw = rotateEvent.isCancelled() ? (double)player.getYRot() : rotateEvent.toRotation().y();
                    actualPitch = rotateEvent.isCancelled() ? (double)player.getXRot() : rotateEvent.toRotation().x();
                }
                this.shadow$setCamera((net.minecraft.world.entity.Entity)player);
                this.shadow$stopRiding();
                if (player.isSleeping()) {
                    player.stopSleepInBed(true, true);
                }
                player.connection.teleport(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch);
                player.setYHeadRot((float)actualYaw);
                ChunkPos chunkpos = new ChunkPos(new BlockPos(actualX, actualY, actualZ));
                world.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getId());
            } else {
                RotateEntityEvent rotateEvent;
                ChangeEntityWorldEvent.Pre preEvent = PlatformHooks.INSTANCE.getEventHooks().callChangeEntityWorldEventPre((net.minecraft.world.entity.Entity)player, world);
                if (SpongeCommon.post(preEvent)) {
                    return;
                }
                if (ShouldFire.MOVE_ENTITY_EVENT) {
                    ChangeEntityWorldEvent.Reposition posEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.currentCause(), (Entity)player, preEvent.originalWorld(), VecHelper.toVector3d(player.position()), new Vector3d(x, y, z), preEvent.originalDestinationWorld(), new Vector3d(x, y, z), preEvent.destinationWorld());
                    if (SpongeCommon.post(posEvent)) {
                        return;
                    }
                    actualX = posEvent.destinationPosition().x();
                    actualY = posEvent.destinationPosition().y();
                    actualZ = posEvent.destinationPosition().z();
                }
                this.shadow$setPos(actualX, actualY, actualZ);
                if (ShouldFire.ROTATE_ENTITY_EVENT && !SpongeCommon.post(rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.currentCause(), (Entity)player, new Vector3d(actualYaw, actualPitch, 0.0), new Vector3d(yaw, pitch, 0.0f)))) {
                    actualYaw = (float)rotateEvent.toRotation().x();
                    actualPitch = (float)rotateEvent.toRotation().y();
                }
                this.shadow$setYRot((float)actualYaw);
                this.shadow$setXRot((float)actualPitch);
                EntityUtil.performPostChangePlayerWorldLogic(player, (ServerLevel)preEvent.originalWorld(), (ServerLevel)preEvent.originalDestinationWorld(), (ServerLevel)preEvent.destinationWorld(), false);
            }
        }
    }

    @Override
    protected final void impl$onChangingDimension(ServerLevel target) {
        if (this.level == target) {
            this.isChangingDimension = true;
        }
    }

    @Override
    protected final net.minecraft.world.entity.Entity impl$performGameWinLogic() {
        this.shadow$unRide();
        this.shadow$getLevel().removePlayerImmediately((net.minecraft.server.level.ServerPlayer)this, Entity.RemovalReason.CHANGED_DIMENSION);
        if (!this.wonGame) {
            this.wonGame = true;
            this.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, this.seenCredits ? 0.0f : 1.0f));
            this.seenCredits = true;
        }
        return (net.minecraft.world.entity.Entity)this;
    }

    @Override
    protected final void impl$prepareForPortalTeleport(ServerLevel currentWorld, ServerLevel targetWorld) {
        LevelData levelData = targetWorld.getLevelData();
        this.connection.send((Packet)new ClientboundRespawnPacket(targetWorld.dimensionTypeId(), targetWorld.dimension(), BiomeManager.obfuscateSeed((long)targetWorld.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), targetWorld.isDebug(), targetWorld.isFlat(), 3, this.shadow$getLastDeathLocation()));
        this.connection.send((Packet)new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked()));
        PlayerList playerlist = this.server.getPlayerList();
        playerlist.sendPlayerPermissionLevel((net.minecraft.server.level.ServerPlayer)this);
        currentWorld.removePlayerImmediately((net.minecraft.server.level.ServerPlayer)this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.shadow$unsetRemoved();
    }

    @Override
    protected final void impl$validateEntityAfterTeleport(net.minecraft.world.entity.Entity e, PortalLogic portalLogic) {
        if (e != this) {
            throw new IllegalArgumentException(String.format("Teleporter %s did not return the expected player entity: got %s, expected PlayerEntity %s", portalLogic, e, this));
        }
    }

    @Override
    protected final net.minecraft.world.entity.Entity impl$portalRepositioning(boolean createEndPlatform, ServerLevel serverworld, ServerLevel targetWorld, PortalInfo portalinfo) {
        serverworld.getProfiler().push("moving");
        if (serverworld.dimension() == Level.OVERWORLD && targetWorld.dimension() == Level.NETHER) {
            this.enteredNetherPosition = this.shadow$position();
        } else if (createEndPlatform && targetWorld.dimension() == Level.END) {
            this.shadow$createEndPlatform(targetWorld, new BlockPos(portalinfo.pos));
        }
        serverworld.getProfiler().pop();
        serverworld.getProfiler().push("placing");
        this.shadow$setLevel(targetWorld);
        targetWorld.addDuringPortalTeleport((net.minecraft.server.level.ServerPlayer)this);
        this.shadow$setRot(portalinfo.yRot, portalinfo.xRot);
        this.shadow$absMoveTo(portalinfo.pos.x, portalinfo.pos.y, portalinfo.pos.z);
        serverworld.getProfiler().pop();
        return (net.minecraft.world.entity.Entity)this;
    }

    @Override
    protected final void impl$postPortalForceChangeTasks(net.minecraft.world.entity.Entity entity, ServerLevel targetWorld, boolean isNetherPortal) {
        this.gameMode.setLevel(targetWorld);
        this.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(this.shadow$getAbilities()));
        PlayerList playerlist = this.server.getPlayerList();
        playerlist.sendLevelInfo((net.minecraft.server.level.ServerPlayer)this, targetWorld);
        playerlist.sendAllPlayerInfo((net.minecraft.server.level.ServerPlayer)this);
        Vec3 finalPos = this.shadow$position();
        this.shadow$moveTo(finalPos.x, finalPos.y, finalPos.z);
        for (MobEffectInstance effectinstance : this.shadow$getActiveEffects()) {
            this.connection.send((Packet)new ClientboundUpdateMobEffectPacket(this.shadow$getId(), effectinstance));
        }
        if (isNetherPortal) {
            this.connection.send((Packet)new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
    }

    @Redirect(method={"getExitPortal"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getExitPortal(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/border/WorldBorder;)Ljava/util/Optional;"), to=@At(value="FIELD", opcode=180, target="Lnet/minecraft/server/level/ServerPlayer;level:Lnet/minecraft/world/level/Level;")), at=@At(value="INVOKE", remap=false, target="Ljava/util/Optional;isPresent()Z"))
    private boolean impl$dontCreatePortalIfItsAlreadyBeenAttempted(Optional<?> optional) {
        return this.impl$dontCreateExitPortal || optional.isPresent();
    }

    @Redirect(method={"openMenu", "openHorseInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;closeContainer()V"))
    private void impl$closePreviousContainer(net.minecraft.server.level.ServerPlayer self) {
        this.shadow$doCloseContainer();
    }

    @Overwrite
    public void die(DamageSource cause) {
        boolean flag;
        DestructEntityEvent.Death event = SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((net.minecraft.server.level.ServerPlayer)this), cause, Audiences.server());
        if (event.isCancelled()) {
            return;
        }
        boolean bl = flag = this.level.getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && !event.isMessageCancelled();
        if (flag) {
            net.minecraft.network.chat.Component component = this.shadow$getCombatTracker().getDeathMessage();
            ClientboundPlayerCombatKillPacket packet = new ClientboundPlayerCombatKillPacket(this.shadow$getCombatTracker(), component);
            PacketSender.sendTo((EngineConnection)this.connection, packet, p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s = component.getString(256);
                    MutableComponent itextcomponent1 = net.minecraft.network.chat.Component.translatable((String)"death.attack.message_too_long", (Object[])new Object[]{net.minecraft.network.chat.Component.literal((String)s).withStyle(ChatFormatting.YELLOW)});
                    MutableComponent itextcomponent2 = net.minecraft.network.chat.Component.translatable((String)"death.attack.even_more_magic", (Object[])new Object[]{this.shadow$getDisplayName()}).withStyle(arg_0 -> ServerPlayerMixin.lambda$die$4((net.minecraft.network.chat.Component)itextcomponent1, arg_0));
                    this.connection.send((Packet)new ClientboundPlayerCombatKillPacket(this.shadow$getCombatTracker(), (net.minecraft.network.chat.Component)itextcomponent2));
                }
            });
            Team team = this.shadow$getTeam();
            if (team != null && team.getDeathMessageVisibility() != Team.Visibility.ALWAYS) {
                if (team.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                    this.server.getPlayerList().broadcastSystemToTeam((Player)((net.minecraft.server.level.ServerPlayer)this), component);
                } else if (team.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                    this.server.getPlayerList().broadcastSystemToAllExceptTeam((Player)((net.minecraft.server.level.ServerPlayer)this), component);
                }
            } else {
                Component message = event.message();
                if (message != Component.empty()) {
                    event.audience().ifPresent(eventChannel -> eventChannel.sendMessage(Identity.nil(), message));
                }
            }
        } else {
            this.connection.send((Packet)new ClientboundPlayerCombatKillPacket(this.shadow$getCombatTracker(), (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.empty()));
        }
        this.shadow$removeEntitiesOnShoulder();
        if (this.level.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.shadow$tellNeutralMobsThatIDied();
        }
        this.impl$keepInventory = event.keepInventory();
        if (!this.shadow$isSpectator()) {
            this.shadow$dropAllDeathLoot(cause);
        }
        this.shadow$getScoreboard().forAllObjectives(ObjectiveCriteria.DEATH_COUNT, this.shadow$getScoreboardName(), Score::increment);
        LivingEntity livingentity = this.shadow$getKillCredit();
        if (livingentity != null) {
            this.shadow$awardStat(Stats.ENTITY_KILLED_BY.get((Object)livingentity.getType()));
            livingentity.awardKillScore((net.minecraft.world.entity.Entity)((net.minecraft.server.level.ServerPlayer)this), this.deathScore, cause);
            this.shadow$createWitherRose(livingentity);
        }
        this.level.broadcastEntityEvent((net.minecraft.world.entity.Entity)((net.minecraft.server.level.ServerPlayer)this), (byte)3);
        this.shadow$awardStat(Stats.DEATHS);
        this.shadow$resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH));
        this.shadow$resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
        this.shadow$clearFire();
        this.shadow$setSharedFlag(0, false);
        this.shadow$getCombatTracker().recheckStatus();
    }

    @Redirect(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z"))
    private boolean tracker$useKeepFromBridge(GameRules gameRules, GameRules.Key<?> key, net.minecraft.server.level.ServerPlayer corpse, boolean keepEverything) {
        boolean keep = ((PlayerBridge)corpse).bridge$keepInventory();
        if (!keep) {
            this.shadow$getInventory().replaceWith(corpse.getInventory());
            corpse.getInventory().clearContent();
        }
        return keep;
    }

    @Inject(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="HEAD")})
    private void impl$copyDataOnRespawn(net.minecraft.server.level.ServerPlayer oldPlayer, boolean respawnFromEnd, CallbackInfo ci) {
        if (oldPlayer instanceof DataCompoundHolder) {
            DataCompoundHolder oldEntity = (DataCompoundHolder)oldPlayer;
            DataUtil.syncDataToTag(oldEntity);
            CompoundTag compound = oldEntity.data$getCompound();
            this.data$setCompound(compound);
            DataUtil.syncTagToData(this);
        }
        SpongeAdventure.forEachBossBar(bar -> ((BossEventBridge)bar).bridge$replacePlayer(oldPlayer, (net.minecraft.server.level.ServerPlayer)this));
    }

    @Inject(method={"updateOptions"}, at={@At(value="HEAD")})
    private void impl$handleClientSettings(ServerboundClientInformationPacket packet, CallbackInfo ci) {
        if (!ShouldFire.PLAYER_CHANGE_CLIENT_SETTINGS_EVENT) {
            return;
        }
        Locale newLocale = LocaleCache.getLocale(packet.language());
        ImmutableSet skinParts = (ImmutableSet)Sponge.game().registry(RegistryTypes.SKIN_PART).stream().map(part -> (SpongeSkinPart)part).filter(part -> part.test(packet.modelCustomisation())).collect(ImmutableSet.toImmutableSet());
        int viewDistance = packet.viewDistance();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ChatVisibility visibility = (ChatVisibility)packet.chatVisibility();
            PlayerChangeClientSettingsEvent event = SpongeEventFactory.createPlayerChangeClientSettingsEvent(frame.currentCause(), visibility, (Set<SkinPart>)skinParts, newLocale, (ServerPlayer)((Object)this), packet.chatColors(), viewDistance);
            SpongeCommon.post(event);
        }
    }

    @Inject(method={"updateOptions"}, at={@At(value="TAIL")})
    private void impl$updateTrackedClientSettings(ServerboundClientInformationPacket packet, CallbackInfo ci) {
        Locale newLocale = LocaleCache.getLocale(packet.language());
        this.impl$viewDistance = packet.viewDistance();
        this.bridge$setLanguage(newLocale);
        this.impl$language = newLocale;
    }

    @Override
    public PlayerOwnBorderListener bridge$getWorldBorderListener() {
        return this.impl$borderListener;
    }

    @Inject(method={"sendSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"}, cancellable=true, at={@At(value="HEAD")})
    public void sendMessage(net.minecraft.network.chat.Component $$0, boolean $$1, CallbackInfo ci) {
        if (this.impl$isFake) {
            ci.cancel();
        }
    }

    @Inject(method={"sendChatMessage"}, cancellable=true, at={@At(value="HEAD")})
    public void sendMessage(OutgoingChatMessage $$0, boolean $$1, ChatType.Bound $$2, CallbackInfo ci) {
        if (this.impl$isFake) {
            ci.cancel();
        }
    }

    @Override
    public Scoreboard shadow$getScoreboard() {
        return (Scoreboard)this.impl$scoreboard;
    }

    @Override
    protected void impl$onRightClickEntity(net.minecraft.world.entity.Entity entityToInteractOn, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary((net.minecraft.server.level.ServerPlayer)this, this.shadow$getItemInHand(hand), entityToInteractOn, hand, null);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Override
    public Team shadow$getTeam() {
        return ((Scoreboard)this.impl$scoreboard).getPlayersTeam(this.shadow$getScoreboardName());
    }

    @Inject(method={"startSleepInBed"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$onReturnSleep(BlockPos param0, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        Either returnValue = (Either)cir.getReturnValue();
        if (returnValue.left().isPresent()) {
            switch ((Player.BedSleepingProblem)returnValue.left().get()) {
                case NOT_POSSIBLE_HERE: 
                case TOO_FAR_AWAY: 
                case NOT_POSSIBLE_NOW: 
                case OBSTRUCTED: 
                case NOT_SAFE: {
                    Cause currentCause = Sponge.server().causeStackManager().currentCause();
                    BlockSnapshot snapshot = ((ServerWorld)this.level).createSnapshot(param0.getX(), param0.getY(), param0.getZ());
                    if (!Sponge.eventManager().post(SpongeEventFactory.createSleepingEventFailed(currentCause, snapshot, (Living)((Object)this)))) break;
                    Either var5 = super.shadow$startSleepInBed(param0).ifRight(param0x -> {
                        this.shadow$awardStat(Stats.SLEEP_IN_BED);
                        CriteriaTriggers.SLEPT_IN_BED.trigger((net.minecraft.server.level.ServerPlayer)this);
                    });
                    ((ServerLevel)this.level).updateSleepingPlayerList();
                    cir.setReturnValue((Object)var5);
                    break;
                }
            }
        }
    }

    @Override
    protected void impl$capturePlayerPosition(double x, double y, double z, CallbackInfo ci) {
        if (this.connection != null) {
            ((ServerGamePacketListenerImplBridge)this.connection).bridge$captureCurrentPlayerPosition();
        }
    }

    @Override
    protected void impl$updateHealthForUseFinish(CallbackInfo ci) {
        this.bridge$refreshScaledHealth();
    }

    private static /* synthetic */ Style lambda$die$4(net.minecraft.network.chat.Component itextcomponent1, Style p_212357_1_) {
        return p_212357_1_.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)itextcomponent1));
    }
}

