/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.world.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.PrettyPrinter;

@Mixin(value={LivingEntity.class}, priority=900)
public abstract class LivingEntityMixin_Attack_impl
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    private DamageSource lastDamageSource;
    @Shadow
    public float animationSpeed;
    @Shadow
    protected float lastHurt;
    @Shadow
    protected int noActionTime;
    @Shadow
    public int hurtDuration;
    @Shadow
    public int hurtTime;
    @Shadow
    public float hurtDir;
    @Shadow
    protected int lastHurtByPlayerTime;
    @Shadow
    @javax.annotation.Nullable
    protected Player lastHurtByPlayer;
    @Shadow
    private long lastDamageStamp;

    @Shadow
    public abstract boolean shadow$hasEffect(MobEffect var1);

    @Shadow
    public abstract boolean shadow$isSleeping();

    @Shadow
    public abstract void shadow$stopSleeping();

    @Shadow
    protected abstract boolean shadow$isDamageSourceBlocked(DamageSource var1);

    @Shadow
    protected abstract void shadow$actuallyHurt(DamageSource var1, float var2);

    @Shadow
    public abstract void shadow$setLastHurtByMob(@Nullable LivingEntity var1);

    @Shadow
    public abstract void shadow$knockback(double var1, double var3, double var5);

    @Shadow
    protected abstract boolean shadow$checkTotemDeathProtection(DamageSource var1);

    @Shadow
    @javax.annotation.Nullable
    protected abstract SoundEvent shadow$getDeathSound();

    @Shadow
    protected abstract float shadow$getSoundVolume();

    @Shadow
    protected abstract float shadow$getVoicePitch();

    @Shadow
    public abstract void shadow$die(DamageSource var1);

    @Shadow
    protected abstract void shadow$playHurtSound(DamageSource var1);

    @Shadow
    public abstract boolean shadow$isDeadOrDying();

    @Overwrite
    public boolean hurt(DamageSource source, float amount) {
        boolean flag2;
        boolean flag;
        this.lastDamageSource = source;
        if (source == null) {
            new PrettyPrinter(60).centre().add("Null DamageSource").hr().addWrapped("Sponge has found a null damage source! This should NEVER happen as the DamageSource is used for all sorts of calculations. Usually this can be considered developer error. Please report the following stacktrace to the most appropriate mod/plugin available.", new Object[0]).add().add(new IllegalArgumentException("Null DamageSource")).log(SpongeCommon.logger(), Level.WARN);
            return false;
        }
        if (!this.bridge$onLivingAttack((LivingEntity)this, source, amount)) {
            return false;
        }
        if (this.shadow$isInvulnerableTo(source)) {
            return false;
        }
        if (this.level.isClientSide) {
            return false;
        }
        if (this.shadow$isDeadOrDying() && source != SpongeDamageSources.IGNORED) {
            return false;
        }
        if (source.isFire() && this.shadow$hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.shadow$isSleeping() && !this.level.isClientSide) {
            this.shadow$stopSleeping();
        }
        this.noActionTime = 0;
        float f = amount;
        float f1 = 0.0f;
        boolean bl = flag = amount > 0.0f && this.shadow$isDamageSourceBlocked(source);
        if (flag) {
            f1 = amount;
        }
        this.animationSpeed = 1.5f;
        boolean flag1 = true;
        if ((float)this.invulnerableTime > 10.0f) {
            if (amount <= this.lastHurt) {
                return false;
            }
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$actuallyHurt(source, amount - this.lastHurt);
            } else if (!this.bridge$damageEntity(source, amount - this.lastHurt)) {
                return false;
            }
            this.lastHurt = amount;
            flag1 = false;
        } else {
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$actuallyHurt(source, amount);
            } else if (!this.bridge$damageEntity(source, amount)) {
                return false;
            }
            this.lastHurt = amount;
            this.invulnerableTime = 20;
            this.hurtTime = this.hurtDuration = 10;
        }
        this.hurtDir = 0.0f;
        Entity entity = source.getEntity();
        if (entity != null) {
            TamableAnimal wolfentity;
            if (entity instanceof LivingEntity) {
                this.shadow$setLastHurtByMob((LivingEntity)entity);
            }
            if (entity instanceof Player) {
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = (Player)entity;
            } else if (entity instanceof TamableAnimal && (wolfentity = (TamableAnimal)entity).isTame()) {
                this.lastHurtByPlayerTime = 100;
                LivingEntity livingentity = wolfentity.getOwner();
                this.lastHurtByPlayer = livingentity != null && livingentity.getType() == EntityType.PLAYER ? (Player)livingentity : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.level.broadcastEntityEvent((Entity)((LivingEntity)this), (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).isThorns()) {
                this.level.broadcastEntityEvent((Entity)((LivingEntity)this), (byte)33);
            } else {
                int b0 = source == DamageSource.DROWN ? 36 : (source.isFire() ? 37 : (source == DamageSource.SWEET_BERRY_BUSH ? 44 : (source == DamageSource.FREEZE ? 57 : 2)));
                this.level.broadcastEntityEvent((Entity)((LivingEntity)this), (byte)b0);
            }
            if (source != DamageSource.DROWN && !flag) {
                this.shadow$markHurt();
            }
            if (entity != null) {
                double d1 = entity.getX() - this.shadow$getX();
                double d0 = entity.getZ() - this.shadow$getZ();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.hurtDir = (float)(Mth.atan2((double)d0, (double)d1) * 57.2957763671875 - (double)this.shadow$getYRot());
                this.shadow$knockback(0.4f, d1, d0);
            } else {
                this.hurtDir = (float)(Math.random() * 2.0 * 180.0);
            }
        }
        if (this.shadow$isDeadOrDying()) {
            if (!this.shadow$checkTotemDeathProtection(source)) {
                SoundEvent soundevent = this.shadow$getDeathSound();
                if (this.bridge$vanishState().createsSounds() && flag1 && soundevent != null) {
                    this.shadow$playSound(soundevent, this.shadow$getSoundVolume(), this.shadow$getVoicePitch());
                }
                this.shadow$die(source);
            }
        } else if (flag1 && this.bridge$vanishState().createsSounds()) {
            this.shadow$playHurtSound(source);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = source;
            this.lastDamageStamp = this.level.getGameTime();
        }
        if ((LivingEntity)this instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f1 * 10.0f));
            }
        }
        if (entity instanceof ServerPlayer) {
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)entity, (Entity)this, source, f, amount, flag);
        }
        return flag2;
    }
}

