/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin_Menu_Inventory
implements MenuBridge {
    @Shadow
    @Final
    private NonNullList<ItemStack> lastSlots;
    @Shadow
    @Final
    public NonNullList<Slot> slots;
    @Nullable
    private SpongeInventoryMenu impl$menu;

    @Shadow
    public abstract void shadow$sendAllDataToRemote();

    @Override
    public void bridge$setMenu(SpongeInventoryMenu menu) {
        this.impl$menu = menu;
    }

    @Override
    @Nullable
    public SpongeInventoryMenu bridge$getMenu() {
        return this.impl$menu;
    }

    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onClick(int slotId, int dragType, ClickType clickTypeIn, Player player, CallbackInfo ci) {
        SpongeInventoryMenu menu = this.bridge$getMenu();
        if (menu != null && !menu.onClick(slotId, dragType, clickTypeIn, player, (Container)((Object)this))) {
            ci.cancel();
            for (int i = 0; i < this.slots.size(); ++i) {
                Slot slot = (Slot)this.slots.get(i);
                this.lastSlots.set(i, (Object)slot.getItem().copy());
            }
            this.shadow$sendAllDataToRemote();
        }
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void impl$onOnContainerClosed(Player player, CallbackInfo ci) {
        SpongeInventoryMenu menu = this.bridge$getMenu();
        if (menu != null) {
            menu.onClose(player, (Container)((Object)this));
        }
        this.bridge$setMenu(null);
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;mayPlace(Lnet/minecraft/world/item/ItemStack;)Z"))
    public boolean impl$onClickMayPlace(Slot slot, ItemStack stack) {
        return this.impl$onMayPlace(slot, stack);
    }

    @Redirect(method={"moveItemStackTo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;mayPlace(Lnet/minecraft/world/item/ItemStack;)Z"))
    public boolean impl$onMoveMayPlace(Slot slot, ItemStack stack) {
        return this.impl$onMayPlace(slot, stack);
    }

    private boolean impl$onMayPlace(Slot slot, ItemStack stack) {
        if (this.bridge$isReadonlyMenu(slot)) {
            this.bridge$refreshListeners();
            return false;
        }
        return slot.mayPlace(stack);
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;mayPickup(Lnet/minecraft/world/entity/player/Player;)Z"))
    public boolean impl$verifyReadOnlyMenu(Slot slot, Player player) {
        if (this.bridge$isReadonlyMenu(slot)) {
            this.bridge$refreshListeners();
            return false;
        }
        return slot.mayPickup(player);
    }

    @Redirect(method={"moveItemStackTo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;getItem()Lnet/minecraft/world/item/ItemStack;", ordinal=0))
    public ItemStack impl$beforeMergeStack(Slot slot) {
        if (this.bridge$isReadonlyMenu(slot)) {
            this.bridge$refreshListeners();
            return ItemStack.EMPTY;
        }
        return slot.getItem();
    }

    @Override
    public boolean bridge$isReadonlyMenu(Slot slot) {
        return this.impl$menu != null && this.impl$menu.isReadOnly() && slot.container == this.impl$menu.inventory();
    }

    @Override
    public void bridge$refreshListeners() {
        this.shadow$sendAllDataToRemote();
    }
}

