/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.TimeoutException;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;

public final class TransactionStore {
    private final Supplier<EngineConnection> connection;
    private final ConcurrentMap<Integer, Entry> lookup = Caffeine.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).removalListener((key, value, cause) -> {
        if (cause == RemovalCause.EXPIRED && value != null) {
            value.getChannel().handleTransactionResponse(this.getConnection(), value.getData(), TransactionResult.failure(new TimeoutException()));
        }
    }).build().asMap();

    public TransactionStore(Supplier<EngineConnection> connection) {
        this.connection = connection;
    }

    public EngineConnection getConnection() {
        return this.connection.get();
    }

    public int nextId() {
        int id;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (this.lookup.containsKey(id = random.nextInt())) {
        }
        return id;
    }

    public void put(int transactionId, SpongeChannel channel, Object stored) {
        this.lookup.put(transactionId, new Entry(channel, stored));
    }

    public @Nullable Entry remove(int transactionId) {
        return (Entry)this.lookup.remove(transactionId);
    }

    public boolean isEmpty() {
        return this.lookup.isEmpty();
    }

    public static class Entry {
        private final SpongeChannel channel;
        private final Object data;

        public Entry(SpongeChannel channel, Object data) {
            this.channel = channel;
            this.data = data;
        }

        public SpongeChannel getChannel() {
            return this.channel;
        }

        public Object getData() {
            return this.data;
        }
    }
}

