/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.packet;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnectionTypes;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.RequestBlockTrackerDataPacket;
import org.spongepowered.common.network.packet.RequestEntityTrackerDataPacket;
import org.spongepowered.common.network.packet.TrackerDataResponsePacket;

public final class SpongePacketHandler {
    private static PacketChannel channel;

    public static void init(SpongeChannelManager registry) {
        channel = registry.createChannel(ResourceKey.sponge("default"), PacketChannel.class);
        channel.registerTransactional(RequestBlockTrackerDataPacket.class, TrackerDataResponsePacket.class, 0).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.player();
            if (!player.hasPermission("sponge.debug.block-tracking")) {
                return;
            }
            net.minecraft.server.level.ServerPlayer sender = (net.minecraft.server.level.ServerPlayer)player;
            BlockPos pos = new BlockPos(requestPacket.x, requestPacket.y, requestPacket.z);
            if (!sender.level.hasChunkAt(pos)) {
                return;
            }
            LevelChunkBridge levelChunkBridge = (LevelChunkBridge)sender.level.getChunkAt(pos);
            Optional<UUID> owner = levelChunkBridge.bridge$getBlockCreatorUUID(pos);
            Optional<UUID> notifier = levelChunkBridge.bridge$getBlockNotifierUUID(pos);
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.registerTransactional(RequestEntityTrackerDataPacket.class, TrackerDataResponsePacket.class, 1).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.player();
            if (!player.hasPermission("sponge.debug.entity-tracking")) {
                return;
            }
            net.minecraft.server.level.ServerPlayer sender = (net.minecraft.server.level.ServerPlayer)player;
            Entity entity = sender.level.getEntity(requestPacket.entityId);
            if (!(entity instanceof CreatorTrackedBridge)) {
                return;
            }
            CreatorTrackedBridge creatorTrackedBridge = (CreatorTrackedBridge)entity;
            Optional<UUID> owner = creatorTrackedBridge.tracker$getCreatorUUID();
            Optional<UUID> notifier = creatorTrackedBridge.tracker$getNotifierUUID();
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.register(ChangeViewerEnvironmentPacket.class, 3).addHandler(ClientSideConnection.class, (packet, connection) -> {
            ClientLevel world = Minecraft.getInstance().level;
            if (world == null) {
                return;
            }
            DimensionType dimensionType = (DimensionType)SpongeCommon.vanillaRegistry(Registries.DIMENSION_TYPE).get(packet.dimensionLogic);
            ((LevelBridge)world).bridge$adjustDimensionLogic(dimensionType);
        });
    }

    private static TrackerDataResponsePacket createTrackerDataResponse(Optional<UUID> owner, Optional<UUID> notifier) {
        String ownerName = owner.flatMap(x -> SpongeCommon.server().getProfileCache().get(x)).map(GameProfile::getName).orElse("");
        String notifierName = notifier.flatMap(x -> SpongeCommon.server().getProfileCache().get(x)).map(GameProfile::getName).orElse("");
        return new TrackerDataResponsePacket(ownerName, notifierName);
    }

    public static PacketChannel getChannel() {
        return Objects.requireNonNull(channel);
    }
}

