/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;

public class SpongeSubjectReference
implements SubjectReference {
    private final SpongePermissionService service;
    private final String collectionId;
    private final String subjectId;
    private @Nullable SpongeSubject cache;

    public SpongeSubjectReference(SpongePermissionService service, String collectionId, String subjectId) {
        this.service = service;
        this.collectionId = collectionId;
        this.subjectId = subjectId;
    }

    @Override
    public String collectionIdentifier() {
        return this.collectionId;
    }

    @Override
    public String subjectIdentifier() {
        return this.subjectId;
    }

    public synchronized CompletableFuture<Subject> resolve() {
        if (this.cache == null) {
            this.cache = this.service.get(this.collectionId).get(this.subjectId);
        }
        return CompletableFuture.completedFuture(this.cache);
    }
}

