/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.common.accessor.world.level.biome.OverworldBiomeBuilderAccessor;

public final class SpongeBiomeAttributesFactory
implements BiomeAttributes.Factory {
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private static Map<org.spongepowered.api.ResourceKey, BiomeAttributes> DEFAULT_ATTRIBUTES;

    @Override
    public BiomeAttributes ofPoint(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        Climate.Parameter mcTemperature = Climate.Parameter.point((float)temperature);
        Climate.Parameter mcHumidity = Climate.Parameter.point((float)humidity);
        Climate.Parameter mcContinentalness = Climate.Parameter.point((float)continentalness);
        Climate.Parameter mcErosion = Climate.Parameter.point((float)erosion);
        Climate.Parameter mcDepth = Climate.Parameter.point((float)depth);
        Climate.Parameter mcWeirdness = Climate.Parameter.point((float)weirdness);
        long mcOffset = Climate.quantizeCoord((float)offset);
        return (BiomeAttributes)new Climate.ParameterPoint(mcTemperature, mcHumidity, mcContinentalness, mcErosion, mcDepth, mcWeirdness, mcOffset);
    }

    @Override
    public BiomeAttributes ofRange(Range<Float> temperature, Range<Float> humidity, Range<Float> continentalness, Range<Float> erosion, Range<Float> depth, Range<Float> weirdness, float offset) {
        Climate.Parameter mcTemperature = Climate.Parameter.span((float)temperature.min().floatValue(), (float)temperature.max().floatValue());
        Climate.Parameter mcHumidity = Climate.Parameter.span((float)humidity.min().floatValue(), (float)humidity.max().floatValue());
        Climate.Parameter mcContinentalness = Climate.Parameter.span((float)continentalness.min().floatValue(), (float)continentalness.max().floatValue());
        Climate.Parameter mcErosion = Climate.Parameter.span((float)erosion.min().floatValue(), (float)erosion.max().floatValue());
        Climate.Parameter mcDepth = Climate.Parameter.span((float)depth.min().floatValue(), (float)depth.max().floatValue());
        Climate.Parameter mcWeirdness = Climate.Parameter.span((float)weirdness.min().floatValue(), (float)weirdness.max().floatValue());
        long mcOffset = Climate.quantizeCoord((float)offset);
        return (BiomeAttributes)new Climate.ParameterPoint(mcTemperature, mcHumidity, mcContinentalness, mcErosion, mcDepth, mcWeirdness, mcOffset);
    }

    @Override
    public Range<Float> fullRange() {
        return (Range)this.FULL_RANGE;
    }

    @Override
    public Optional<BiomeAttributes> defaultAttributes(RegistryReference<Biome> biome) {
        if (DEFAULT_ATTRIBUTES == null) {
            DEFAULT_ATTRIBUTES = new HashMap<org.spongepowered.api.ResourceKey, BiomeAttributes>();
            ImmutableList.Builder list = ImmutableList.builder();
            ((OverworldBiomeBuilderAccessor)new OverworldBiomeBuilder()).accessor$addBiomes(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
            for (Pair pair : list.build()) {
                DEFAULT_ATTRIBUTES.put((org.spongepowered.api.ResourceKey)((ResourceKey)pair.getSecond()).location(), (BiomeAttributes)pair.getFirst());
            }
            DEFAULT_ATTRIBUTES.put((org.spongepowered.api.ResourceKey)Biomes.SOUL_SAND_VALLEY.location(), (BiomeAttributes)Climate.parameters((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            DEFAULT_ATTRIBUTES.put((org.spongepowered.api.ResourceKey)Biomes.CRIMSON_FOREST.location(), (BiomeAttributes)Climate.parameters((float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            DEFAULT_ATTRIBUTES.put((org.spongepowered.api.ResourceKey)Biomes.WARPED_FOREST.location(), (BiomeAttributes)Climate.parameters((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.375f));
            DEFAULT_ATTRIBUTES.put((org.spongepowered.api.ResourceKey)Biomes.BASALT_DELTAS.location(), (BiomeAttributes)Climate.parameters((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.175f));
        }
        return Optional.ofNullable(DEFAULT_ATTRIBUTES.get(biome.location()));
    }
}

