/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.biome.MultiNoiseBiomeSourceAccessor;
import org.spongepowered.common.world.biome.provider.AbstractBiomeProviderConfig;

public final class SpongeMultiNoiseBiomeConfig
extends AbstractBiomeProviderConfig
implements MultiNoiseBiomeConfig {
    private final List<AttributedBiome> biomes;

    private SpongeMultiNoiseBiomeConfig(BuilderImpl builder) {
        super(builder.biomes.stream().map(AttributedBiome::biome).collect(Collectors.toList()));
        this.biomes = builder.biomes;
    }

    @Override
    public List<AttributedBiome> attributedBiomes() {
        return this.biomes;
    }

    public static final class BuilderImpl
    implements MultiNoiseBiomeConfig.Builder {
        public final List<AttributedBiome> biomes = new ArrayList<AttributedBiome>();

        @Override
        public MultiNoiseBiomeConfig.Builder addBiome(AttributedBiome biome) {
            this.biomes.add(Objects.requireNonNull(biome, "biome"));
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder addBiomes(List<AttributedBiome> biomes) {
            this.biomes.addAll((Collection<AttributedBiome>)Objects.requireNonNull(biomes, "biomes"));
            return this;
        }

        public MultiNoiseBiomeConfig.Builder addMcBiomes(Climate.ParameterList<Holder<Biome>> biomes) {
            for (Pair pair : biomes.values()) {
                ResourceKey key = RegistryTypes.BIOME.keyFor(Sponge.server(), (org.spongepowered.api.world.biome.Biome)((Holder)pair.getSecond()).value());
                RegistryReference<org.spongepowered.api.world.biome.Biome> biome = RegistryTypes.BIOME.referenced(key);
                this.biomes.add(AttributedBiome.of(biome, (BiomeAttributes)pair.getFirst()));
            }
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder removeBiome(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
            Objects.requireNonNull(biome, "biome");
            Iterator<AttributedBiome> iter = this.biomes.iterator();
            while (iter.hasNext()) {
                if (!iter.next().biome().equals(biome)) continue;
                iter.remove();
                break;
            }
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder from(MultiNoiseBiomeConfig value) {
            this.biomes.clear();
            this.biomes.addAll(value.attributedBiomes());
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder reset() {
            this.biomes.clear();
            return this;
        }

        public @NonNull MultiNoiseBiomeConfig build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("MultiNoise biome config requires at least one biome!");
            }
            return new SpongeMultiNoiseBiomeConfig(this);
        }
    }

    public static final class FactoryImpl
    implements MultiNoiseBiomeConfig.Factory {
        @Override
        public MultiNoiseBiomeConfig nether() {
            Registry biomeRegistry = SpongeCommon.vanillaRegistry(Registries.BIOME);
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)MultiNoiseBiomeSource.Preset.NETHER.biomeSource((HolderGetter)biomeRegistry.asLookup());
            return (MultiNoiseBiomeConfig)new BuilderImpl().addMcBiomes(biomeSource.accessor$parameters()).build();
        }

        @Override
        public MultiNoiseBiomeConfig overworld() {
            Registry biomeRegistry = SpongeCommon.vanillaRegistry(Registries.BIOME);
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)MultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource((HolderGetter)biomeRegistry.asLookup());
            return (MultiNoiseBiomeConfig)new BuilderImpl().addMcBiomes(biomeSource.accessor$parameters()).build();
        }
    }
}

