/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.util;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;

public class CaptureAppender
extends AbstractAppender {
    private final Queue<String> messages = new ConcurrentLinkedQueue<String>();

    public static Builder builder() {
        return new Builder();
    }

    protected CaptureAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        this.messages.add(event.getMessage().getFormattedMessage());
    }

    public Queue<String> messages() {
        return this.messages;
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder> {
        Builder() {
        }

        public CaptureAppender build() {
            Layout layout = this.getOrCreateLayout();
            return new CaptureAppender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)layout, this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }
}

