/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.util;

import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.DenyAllFilter;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.intellij.lang.annotations.Language;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.vanilla.applaunch.util.CaptureAppender;

public final class MixinLoggerInjector {
    private MixinLoggerInjector() {
    }

    private static RegexFilter pattern(@Language(value="RegExp") String pattern) {
        try {
            return RegexFilter.createFilter((String)pattern, (String[])new String[0], (Boolean)false, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Queue<String> captureLogger() {
        if (!MixinEnvironment.getDefaultEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            throw new IllegalStateException("Mixin capture will not function appropriately unless -Dmixin.debug.verbose is enabled");
        }
        Logger mixinLogger = (Logger)LogManager.getLogger((String)"mixin");
        CompositeFilter messageFilter = CompositeFilter.createFilters((Filter[])new Filter[]{MixinLoggerInjector.pattern(".*for final field [^@]+@Mutable.*"), DenyAllFilter.newBuilder().build()});
        CaptureAppender appender = ((CaptureAppender.Builder)((CaptureAppender.Builder)CaptureAppender.builder().setName("IntegrationTest-Capture")).setFilter((Filter)messageFilter)).build();
        appender.start();
        mixinLogger.addAppender((Appender)appender);
        return appender.messages();
    }
}

