/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity.living;

import java.util.Optional;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.attribute.AttributeHolder;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.vector.Vector3d;

public interface Living
extends AttributeHolder,
Entity {
    default public Value.Mutable<Double> absorption() {
        return this.requireValue(Keys.ABSORPTION).asMutable();
    }

    default public Value.Mutable<ItemStackSnapshot> activeItem() {
        return this.requireValue(Keys.ACTIVE_ITEM).asMutable();
    }

    default public Value.Mutable<Double> health() {
        return this.requireValue(Keys.HEALTH).asMutable();
    }

    default public Value.Mutable<Double> maxHealth() {
        return this.requireValue(Keys.MAX_HEALTH).asMutable();
    }

    default public Optional<Value.Mutable<Entity>> lastAttacker() {
        return this.getValue(Keys.LAST_ATTACKER).map(Value::asMutable);
    }

    default public Value.Mutable<Vector3d> headRotation() {
        return this.requireValue(Keys.HEAD_ROTATION).asMutable();
    }

    default public Value.Mutable<Double> lastDamageReceived() {
        return this.requireValue(Keys.LAST_DAMAGE_RECEIVED).asMutable();
    }

    default public Value.Mutable<Integer> stuckArrows() {
        return this.requireValue(Keys.STUCK_ARROWS).asMutable();
    }

    default public Value.Mutable<Double> walkingSpeed() {
        return this.requireValue(Keys.WALKING_SPEED).asMutable();
    }

    default public MapValue.Mutable<BodyPart, Vector3d> bodyRotations() {
        return ((MapValue)this.requireValue(Keys.BODY_ROTATIONS)).asMutable();
    }

    default public Value.Mutable<Vector3d> chestRotation() {
        return this.requireValue(Keys.CHEST_ROTATION).asMutable();
    }

    default public Value.Mutable<Boolean> elytraFlying() {
        return this.requireValue(Keys.IS_ELYTRA_FLYING).asMutable();
    }

    default public Optional<Value.Mutable<Boolean>> canGrief() {
        return this.getValue(Keys.CAN_GRIEF).map(Value::asMutable);
    }

    default public ListValue.Mutable<PotionEffect> potionEffects() {
        return ((ListValue)this.requireValue(Keys.POTION_EFFECTS)).asMutable();
    }

    default public Vector3d headDirection() {
        Vector3d headRotation = (Vector3d)this.headRotation().get();
        return Quaterniond.fromAxesAnglesDeg((double)headRotation.x(), (double)(-headRotation.y()), (double)headRotation.z()).direction();
    }
}

