/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.impl.entity.AbstractModifierEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.eventgen.UseField;

public abstract class AbstractDamageEntityEvent
extends AbstractModifierEvent<DamageFunction, DamageModifier>
implements DamageEntityEvent {
    @UseField
    protected double originalDamage;
    @UseField
    protected List<DamageFunction> originalFunctions;
    @UseField
    protected double baseDamage;

    @Override
    protected final void init() {
        this.originalFunctions = this.init(this.originalDamage, this.originalFunctions);
        this.baseDamage = this.originalDamage;
    }

    @Override
    public final double originalModifierDamage(DamageModifier damageModifier) {
        Objects.requireNonNull(damageModifier, "The damage modifier cannot be null!");
        for (Tuple tuple : this.originalModifiers) {
            if (!((DamageModifier)tuple.first()).equals(damageModifier)) continue;
            return (Double)tuple.second();
        }
        throw new IllegalArgumentException("The provided damage modifier is not applicable: " + damageModifier.toString());
    }

    @Override
    public final double originalFinalDamage() {
        return this.originalFinalAmount;
    }

    @Override
    public final Map<DamageModifier, Double> originalDamages() {
        return this.originalModifierMap;
    }

    @Override
    public final double finalDamage() {
        return this.finalAmount(this.baseDamage);
    }

    @Override
    public final boolean isModifierApplicable(DamageModifier damageModifier) {
        return this.modifiers.containsKey(Objects.requireNonNull(damageModifier));
    }

    @Override
    public final double damage(DamageModifier damageModifier) {
        if (!this.modifiers.containsKey(Objects.requireNonNull(damageModifier, "Damage Modifier cannot be null!"))) {
            throw new IllegalArgumentException("The provided damage modifier is not applicable: " + damageModifier.toString());
        }
        return (Double)this.modifiers.get(Objects.requireNonNull(damageModifier));
    }

    @Override
    public final void setDamage(DamageModifier damageModifier, DoubleUnaryOperator function) {
        Objects.requireNonNull(damageModifier, "Damage modifier was null!");
        Objects.requireNonNull(function, "Function was null!");
        int indexToAddTo = 0;
        boolean addAtEnd = true;
        Iterator iterator = this.modifierFunctions.iterator();
        while (iterator.hasNext()) {
            ModifierFunction tuple = (ModifierFunction)iterator.next();
            if (((DamageModifier)tuple.modifier()).equals(damageModifier)) {
                iterator.remove();
                addAtEnd = false;
                break;
            }
            ++indexToAddTo;
        }
        if (addAtEnd) {
            this.modifierFunctions.add(new DamageFunction(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddTo, new DamageFunction(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public void addDamageModifierBefore(DamageModifier damageModifier, DoubleUnaryOperator function, Set<DamageModifierType> before) {
        Objects.requireNonNull(damageModifier, "Damage modifier was null!");
        Objects.requireNonNull(function, "Function was null!");
        int indexToAddBefore = -1;
        int index = 0;
        for (ModifierFunction tuple : this.modifierFunctions) {
            if (((DamageModifier)tuple.modifier()).equals(damageModifier)) {
                throw new IllegalArgumentException("Cannot add a duplicate modifier");
            }
            if (before.contains(((DamageModifier)tuple.modifier()).type())) {
                indexToAddBefore = index;
            }
            ++index;
        }
        if (indexToAddBefore == -1) {
            this.modifierFunctions.add(new DamageFunction(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddBefore, new DamageFunction(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public void addModifierAfter(DamageModifier damageModifier, DoubleUnaryOperator function, Set<DamageModifierType> after) {
        Objects.requireNonNull(damageModifier, "Damage modifier was null!");
        Objects.requireNonNull(function, "Function was null!");
        int indexToAddAfter = -1;
        int index = 0;
        for (ModifierFunction tuple : this.modifierFunctions) {
            if (((DamageModifier)tuple.modifier()).equals(damageModifier)) {
                throw new IllegalArgumentException("Cannot add a duplicate modifier");
            }
            if (after.contains(((DamageModifier)tuple.modifier()).type())) {
                indexToAddAfter = index;
            }
            ++index;
        }
        if (indexToAddAfter == -1) {
            this.modifierFunctions.add(new DamageFunction(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddAfter + 1, new DamageFunction(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    protected DamageFunction convertTuple(DamageModifier obj, DoubleUnaryOperator function) {
        return new DamageFunction(obj, function);
    }

    @Override
    public List<DamageFunction> modifiers() {
        return this.modifierFunctions.stream().map(entry -> {
            if (entry instanceof DamageFunction) {
                return (DamageFunction)entry;
            }
            return new DamageFunction((DamageModifier)entry.modifier(), entry.function());
        }).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public double baseDamage() {
        return this.baseDamage;
    }

    @Override
    public final void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public boolean willCauseDeath() {
        Optional health = this.entity().get(Keys.HEALTH);
        return health.isPresent() && (Double)health.get() - this.finalDamage() <= 0.0;
    }
}

