/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.util.Tuple;

public abstract class AbstractModifierEvent<T extends ModifierFunction<M>, M>
extends AbstractEvent {
    protected double originalFinalAmount;
    protected List<Tuple<M, Double>> originalModifiers;
    protected Map<M, Double> originalModifierMap;
    protected final LinkedHashMap<M, Double> modifiers = new LinkedHashMap();
    protected final List<T> modifierFunctions = new ArrayList<T>();

    protected List<T> init(double originalValue, List<T> originalFunctions) {
        ArrayList modifierMapBuilder = new ArrayList(originalFunctions.size());
        ArrayList<T> functionListBuilder = new ArrayList<T>(originalFunctions.size());
        HashMap mapBuilder = new HashMap(originalFunctions.size());
        double finalDamage = originalValue;
        for (ModifierFunction tuple : originalFunctions) {
            this.modifierFunctions.add(this.convertTuple(tuple.modifier(), tuple.function()));
            double tempDamage = tuple.function().applyAsDouble(finalDamage);
            finalDamage += tempDamage;
            modifierMapBuilder.add(new Tuple(tuple.modifier(), tempDamage));
            mapBuilder.put(tuple.modifier(), tempDamage);
            this.modifiers.put(tuple.modifier(), tempDamage);
            functionListBuilder.add(this.convertTuple(tuple.modifier(), tuple.function()));
        }
        this.originalFinalAmount = finalDamage;
        this.originalModifiers = List.copyOf(modifierMapBuilder);
        this.originalModifierMap = Map.copyOf(mapBuilder);
        return List.copyOf(functionListBuilder);
    }

    protected abstract T convertTuple(M var1, DoubleUnaryOperator var2);

    protected void recalculateDamages(double baseAmount) {
        double tempAmount = baseAmount;
        this.modifiers.clear();
        for (ModifierFunction entry : this.modifierFunctions) {
            double modifierAmount = entry.function().applyAsDouble(tempAmount);
            if (this.modifiers.containsKey(entry.modifier())) {
                double oldAmount = this.modifiers.get(entry.modifier());
                double difference = oldAmount - modifierAmount;
                if (oldAmount > 0.0) {
                    this.modifiers.put(entry.modifier(), Math.max(0.0, oldAmount - difference));
                } else {
                    this.modifiers.put(entry.modifier(), Math.min(0.0, oldAmount - difference));
                }
            } else {
                this.modifiers.put(entry.modifier(), modifierAmount);
            }
            tempAmount += modifierAmount;
        }
    }

    protected double finalAmount(double baseAmount) {
        double damage = baseAmount;
        for (ModifierFunction entry : this.modifierFunctions) {
            damage += entry.function().applyAsDouble(damage);
        }
        return damage;
    }

    public List<T> modifiers() {
        return List.copyOf(this.modifierFunctions);
    }
}

