/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import java.util.random.RandomGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;

@FunctionalInterface
public interface SeededVariableAmount<T> {
    public static <T> SeededVariableAmount<T> fixed(double value) {
        return new WrappedVariableAmount(VariableAmount.fixed(value));
    }

    public static <T> SeededVariableAmount<T> wrapped(VariableAmount value) {
        return new WrappedVariableAmount(value);
    }

    public double amount(RandomGenerator var1, T var2);

    default public int flooredAmount(RandomGenerator rand, T seed) {
        return (int)Math.floor(this.amount(rand, seed));
    }

    public static final class WrappedVariableAmount<T>
    implements SeededVariableAmount<T> {
        private final VariableAmount inner;

        public WrappedVariableAmount(VariableAmount inner) {
            this.inner = inner;
        }

        @Override
        public double amount(RandomGenerator rand, T seed) {
            return this.inner.amount(rand);
        }

        public String toString() {
            return this.inner.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WrappedVariableAmount)) {
                return false;
            }
            WrappedVariableAmount var = (WrappedVariableAmount)obj;
            return this.inner.equals(var.inner);
        }

        public int hashCode() {
            return this.inner.hashCode();
        }
    }
}

