/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.archetype.block.entity;

import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.world.volume.ImmutableVolume;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector3i;

public interface BlockEntityArchetypeVolume
extends BlockVolume {
    public Optional<BlockEntityArchetype> blockEntityArchetype(int var1, int var2, int var3);

    default public Optional<BlockEntityArchetype> blockEntityArchetype(Vector3i position) {
        return this.blockEntityArchetype(position.x(), position.y(), position.z());
    }

    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes();

    public static interface Immutable
    extends Unmodifiable<Immutable>,
    ImmutableVolume {
    }

    public static interface Mutable
    extends Modifiable<Mutable> {
    }

    public static interface Modifiable<M extends Modifiable<M>>
    extends Streamable<M>,
    BlockVolume.Modifiable<M>,
    MutableVolume {
        default public void addBlockEntity(Vector3i pos, BlockEntity blockEntity) {
            this.addBlockEntity(pos.x(), pos.y(), pos.z(), blockEntity);
        }

        default public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
            this.addBlockEntity(x, y, z, blockEntity.createArchetype());
        }

        default public void addBlockEntity(Vector3i pos, BlockEntityArchetype archetype) {
            this.addBlockEntity(pos.x(), pos.y(), pos.z(), archetype);
        }

        public void addBlockEntity(int var1, int var2, int var3, BlockEntityArchetype var4);

        default public void removeBlockEntity(Vector3i pos) {
            this.removeBlockEntity(pos.x(), pos.y(), pos.z());
        }

        public void removeBlockEntity(int var1, int var2, int var3);
    }

    public static interface Unmodifiable<U extends Unmodifiable<U>>
    extends BlockEntityArchetypeVolume,
    Streamable<U>,
    UnmodifiableVolume,
    BlockVolume.Unmodifiable<U> {
    }

    public static interface Streamable<B extends Streamable<B>>
    extends BlockEntityArchetypeVolume {
        public VolumeStream<B, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i var1, Vector3i var2, StreamOptions var3);
    }
}

