/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Coerce {
    private static final Pattern listPattern = Pattern.compile("^([\\(\\[\\{]?)(.+?)([\\)\\]\\}]?)$");
    private static final String[] listPairings = new String[]{"([{", ")]}"};

    private Coerce() {
    }

    public static Optional<String> asString(@Nullable Object obj) {
        if (obj instanceof String) {
            return Optional.of((String)obj);
        }
        if (obj == null) {
            return Optional.empty();
        }
        return Optional.of(obj.toString());
    }

    public static Optional<Boolean> asBoolean(@Nullable Object obj) {
        if (obj instanceof Boolean) {
            return Optional.of((Boolean)obj);
        }
        if (obj instanceof Byte) {
            return Optional.of((Byte)obj != 0);
        }
        return Optional.empty();
    }

    public static Optional<Integer> asInteger(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).intValue());
        }
        try {
            return Optional.ofNullable(Integer.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj);
            Integer iParsed = Ints.tryParse((String)strObj);
            if (iParsed == null) {
                Double dParsed = Doubles.tryParse((String)strObj);
                return dParsed == null ? Optional.empty() : Optional.of(dParsed.intValue());
            }
            return Optional.of(iParsed);
        }
    }

    public static Optional<Double> asDouble(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).doubleValue());
        }
        try {
            return Optional.ofNullable(Double.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj);
            Double dParsed = Doubles.tryParse((String)strObj);
            return dParsed == null ? Optional.empty() : Optional.of(dParsed);
        }
    }

    public static Optional<Float> asFloat(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(Float.valueOf(((Number)obj).floatValue()));
        }
        try {
            return Optional.ofNullable(Float.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj);
            Double dParsed = Doubles.tryParse((String)strObj);
            return dParsed == null ? Optional.empty() : Optional.of(Float.valueOf(dParsed.floatValue()));
        }
    }

    public static Optional<Short> asShort(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).shortValue());
        }
        try {
            return Optional.ofNullable(Short.parseShort(Coerce.sanitiseNumber(obj)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static Optional<Byte> asByte(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).byteValue());
        }
        try {
            return Optional.ofNullable(Byte.parseByte(Coerce.sanitiseNumber(obj)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static Optional<Long> asLong(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).longValue());
        }
        try {
            return Optional.ofNullable(Long.parseLong(Coerce.sanitiseNumber(obj)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static Optional<Character> asChar(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Character) {
            return Optional.of((Character)obj);
        }
        try {
            return Optional.of(Character.valueOf(obj.toString().charAt(0)));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static String sanitiseNumber(Object obj) {
        String string = obj.toString().trim();
        if (string.length() < 1) {
            return "0";
        }
        Matcher candidate = listPattern.matcher(string);
        if (Coerce.listBracketsMatch(candidate)) {
            string = candidate.group(2).trim();
        }
        int decimal = string.indexOf(46);
        int comma = string.indexOf(44, decimal);
        if (decimal > -1 && comma > -1) {
            return Coerce.sanitiseNumber(string.substring(0, comma));
        }
        if (string.indexOf(45, 1) != -1) {
            return "0";
        }
        return string.replace(",", "").split(" ", 0)[0];
    }

    private static boolean listBracketsMatch(Matcher candidate) {
        return candidate.matches() && listPairings[0].indexOf(candidate.group(1)) == listPairings[1].indexOf(candidate.group(3));
    }
}

