/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.data.DataDeserializer;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;
import org.spongepowered.common.data.persistence.datastore.VanillaDataStore;
import org.spongepowered.configurate.util.Types;

public final class SpongeDataStoreBuilder
implements DataStore.Builder,
DataStore.Builder.UpdaterStep,
DataStore.Builder.HolderStep,
DataStore.Builder.SerializersStep,
DataStore.Builder.EndStep {
    private final Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> serializers = new IdentityHashMap();
    private final List<Type> dataHolderTypes = new ArrayList<Type>();
    private @Nullable ResourceKey key;
    private int version = 1;
    private DataContentUpdater[] updaters = new DataContentUpdater[0];

    @Override
    public <T, V extends Value<T>> SpongeDataStoreBuilder key(Key<V> key, DataQuery dataQuery) {
        BiFunction deserializer = DataDeserializer.deserializer(key.elementType());
        return this.key((Key)key, (T view, U value) -> view.set(dataQuery, value), (T v) -> (Optional)deserializer.apply((DataView)v, dataQuery));
    }

    public boolean isEmpty() {
        return this.serializers.isEmpty();
    }

    public List<Type> getDataHolderTypes() {
        return this.dataHolderTypes;
    }

    @Override
    public <T, V extends Value<T>> SpongeDataStoreBuilder key(Key<V> key, BiConsumer<DataView, T> serializer, Function<DataView, Optional<T>> deserializer) {
        if (this.key != null) {
            DataQuery query = DataQuery.of(this.key.namespace(), this.key.value());
            SpongeDataSerializer<T> customSerializer = new SpongeDataSerializer<T>(serializer, this.version, query);
            SpongeDataDeserializer<T> customDeserializer = new SpongeDataDeserializer<T>(deserializer, this.version, query);
            this.serializers.put(key, Tuple.of(customSerializer, customDeserializer));
        } else {
            this.serializers.put(key, Tuple.of(serializer, deserializer));
        }
        return this;
    }

    @Override
    public DataStore.Builder.EndStep keys(Key<?> key, Key<?> ... moreKeys) {
        this.key(key, key.key().value());
        for (Key<?> moreKey : moreKeys) {
            this.key(moreKey, moreKey.key().value());
        }
        return this;
    }

    @Override
    public DataStore.Builder reset() {
        this.serializers.clear();
        this.dataHolderTypes.clear();
        this.key = null;
        this.version = 1;
        this.updaters = new DataContentUpdater[0];
        return this;
    }

    @Override
    public SpongeDataStoreBuilder holder(TypeToken<? extends DataHolder> ... typeTokens) {
        for (TypeToken<? extends DataHolder> token : typeTokens) {
            this.dataHolderTypes.add(token.getType());
        }
        return this;
    }

    @Override
    public SpongeDataStoreBuilder holder(Class<? extends DataHolder> ... classes) {
        for (Class<? extends DataHolder> clazz : classes) {
            this.dataHolderTypes.add(Types.requireCompleteParameters(clazz));
        }
        return this;
    }

    @Override
    public SpongeDataStoreBuilder pluginData(ResourceKey key) {
        this.key = key;
        return this;
    }

    @Override
    public SpongeDataStoreBuilder pluginData(ResourceKey key, int version) {
        this.pluginData(key);
        this.version = version;
        return this;
    }

    @Override
    public DataStore.Builder.HolderStep updater(DataContentUpdater ... updaters) {
        this.updaters = updaters;
        return this;
    }

    @Override
    public SpongeDataStoreBuilder vanillaData() {
        this.key = null;
        return this;
    }

    @Override
    public DataStore build() {
        return new SpongeDataStore(this.key, (Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>>)ImmutableMap.copyOf(this.serializers), (Collection<Type>)ImmutableList.copyOf(this.dataHolderTypes), this.version, this.updaters);
    }

    public DataStore buildVanillaDataStore() {
        return new VanillaDataStore(Collections.unmodifiableMap(this.serializers), this.dataHolderTypes);
    }

    private static class SpongeDataSerializer<T>
    implements BiConsumer<DataView, T> {
        private final BiConsumer<DataView, T> serializer;
        private final DataQuery key;
        private final int version;

        public SpongeDataSerializer(BiConsumer<DataView, T> serializer, int version, DataQuery key) {
            this.serializer = serializer;
            this.key = key;
            this.version = version;
        }

        @Override
        public void accept(DataView view, T v) {
            DataView data = DataUtil.getSpongeData(view, this.key, this.version).orElse(DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED));
            this.serializer.accept(data, (DataView)v);
            if (data.isEmpty()) {
                return;
            }
            DataUtil.setSpongeData(view, this.key, data, this.version);
        }
    }

    private static class SpongeDataDeserializer<T>
    implements Function<DataView, Optional<T>> {
        private final Function<DataView, Optional<T>> deserializer;
        private final DataQuery key;
        private int version;

        public SpongeDataDeserializer(Function<DataView, Optional<T>> deserializer, int version, DataQuery key) {
            this.deserializer = deserializer;
            this.key = key;
            this.version = version;
        }

        @Override
        public Optional<T> apply(DataView view) {
            return DataUtil.getSpongeData(view, this.key, this.version).flatMap(this.deserializer);
        }
    }
}

