/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.data.provider.AbstractDataProvider;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.data.provider.DataProviderRegistratorBuilder;
import org.spongepowered.common.data.provider.DelegateDataProvider;
import org.spongepowered.common.data.provider.EmptyDataProvider;
import org.spongepowered.common.data.provider.block.entity.BlockEntityDataProviders;
import org.spongepowered.common.data.provider.block.location.LocationDataProviders;
import org.spongepowered.common.data.provider.block.state.BlockStateDataProviders;
import org.spongepowered.common.data.provider.entity.EntityDataProviders;
import org.spongepowered.common.data.provider.generic.GenericDataProviders;
import org.spongepowered.common.data.provider.inventory.InventoryDataProviders;
import org.spongepowered.common.data.provider.item.ItemDataProviders;
import org.spongepowered.common.data.provider.item.stack.ItemStackDataProviders;
import org.spongepowered.common.data.provider.map.MapInfoDataProviders;
import org.spongepowered.common.data.provider.nbt.NBTDataProviders;
import org.spongepowered.common.data.provider.world.WorldDataProviders;
import org.spongepowered.common.data.provider.world.biome.BiomeDataProviders;

public final class DataProviderRegistry {
    private final Multimap<Key<?>, DataProvider<?, ?>> dataProviders = HashMultimap.create();
    private final Map<LookupKey, DataProvider<?, ?>> dataProviderCache = new ConcurrentHashMap();
    private final Map<Class<?>, DataProviderLookup> dataProviderLookupCache = new ConcurrentHashMap();

    private static boolean filterHolderType(DataProvider<?, ?> provider, Class<?> holderType) {
        if (provider instanceof AbstractDataProvider.KnownHolderType) {
            Class<?> foundHolderType = ((AbstractDataProvider.KnownHolderType)((Object)provider)).getHolderType();
            return foundHolderType.isAssignableFrom(holderType);
        }
        return true;
    }

    private DataProvider<?, ?> loadProvider(LookupKey key) {
        return this.buildDelegate(key.key, provider -> DataProviderRegistry.filterHolderType(provider, key.holderType));
    }

    private DataProviderLookup loadProviderLookup(Class<?> holderType) {
        Stream<DataProvider> stream = this.dataProviders.keySet().stream().map(key -> this.getProvider((Key)key, holderType)).filter(provider -> !(provider instanceof EmptyDataProvider));
        Map<Key<?>, DataProvider<?, ?>> map = stream.collect(Collectors.toMap(p -> p.key(), p -> p));
        return new DataProviderLookup(map);
    }

    private static <V extends Value<E>, E> DataProvider<V, E> buildDelegateProvider(Key<V> key, List<DataProvider<V, E>> providers) {
        if (providers.isEmpty()) {
            return ((SpongeKey)key).getEmptyDataProvider();
        }
        if (providers.size() == 1) {
            return providers.get(0);
        }
        return new DelegateDataProvider<V, E>(key, providers);
    }

    public DataProviderLookup getProviderLookup(Class<?> dataHolderType) {
        return this.dataProviderLookupCache.computeIfAbsent(dataHolderType, this::loadProviderLookup);
    }

    public DataProviderLookup buildLookup(Predicate<DataProvider<?, ?>> predicate) {
        Stream<DataProvider> stream = this.dataProviders.keySet().stream().map(key -> DataProviderRegistry.buildDelegateProvider(key, (List)((Object)this.dataProviders.get(key).stream().filter(predicate))));
        Map<Key<?>, DataProvider<?, ?>> map = stream.collect(Collectors.toMap(p -> p.key(), p -> p));
        return new DataProviderLookup(map);
    }

    private <V extends Value<E>, E> DataProvider<V, E> buildDelegate(Key<V> key, Predicate<DataProvider<V, E>> predicate) {
        Collection providers = this.dataProviders.get(key);
        return DataProviderRegistry.buildDelegateProvider(key, providers.stream().filter(predicate).collect(Collectors.toList()));
    }

    public Collection<DataProvider<?, ?>> getAllProviders(Class<?> dataHolderType) {
        return this.getProviderLookup(dataHolderType).getAllProviders();
    }

    public <V extends Value<E>, E> DataProvider<V, E> getProvider(Key<V> key, Class<?> dataHolderType) {
        return this.dataProviderCache.computeIfAbsent(new LookupKey(dataHolderType, key), this::loadProvider);
    }

    public void register(DataProvider<?, ?> provider) {
        this.dataProviders.put(provider.key(), provider);
        this.dataProviderCache.clear();
        this.dataProviderLookupCache.clear();
    }

    public void registerDefaultProviders() {
        this.registerDefaultProviders(new LocationDataProviders(), new BlockStateDataProviders(), new NBTDataProviders(), new ItemDataProviders(), new BlockEntityDataProviders(), new GenericDataProviders(), new ItemStackDataProviders(), new InventoryDataProviders(), new EntityDataProviders(), new MapInfoDataProviders(), new BiomeDataProviders(), new WorldDataProviders());
    }

    private void registerDefaultProviders(DataProviderRegistratorBuilder ... dataProviderRegistratorBuilders) {
        for (DataProviderRegistratorBuilder dataProviderRegistratorBuilder : dataProviderRegistratorBuilders) {
            dataProviderRegistratorBuilder.register();
        }
    }

    private static class LookupKey {
        final Class<?> holderType;
        final Key<?> key;

        private LookupKey(Class<?> holderType, Key<?> key) {
            this.holderType = holderType;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupKey lookupKey = (LookupKey)o;
            return this.holderType.equals(lookupKey.holderType) && this.key.equals(lookupKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.holderType, this.key);
        }
    }
}

