/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.world;

import java.util.OptionalLong;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.common.accessor.world.level.dimension.DimensionTypeAccessor;
import org.spongepowered.common.bridge.world.level.dimension.DimensionTypeBridge;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.registry.provider.DimensionEffectProvider;
import org.spongepowered.common.util.SpongeMinecraftDayTime;

public final class WorldTypeData {
    private WorldTypeData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)registrator.asImmutable(DimensionType.class).create(Keys.WORLD_TYPE_EFFECT).get(WorldTypeData::worldTypeEffect)).create(Keys.SCORCHING).get(DimensionType::ultraWarm)).create(Keys.NATURAL_WORLD_TYPE).get(DimensionType::natural)).create(Keys.COORDINATE_MULTIPLIER).get(DimensionType::coordinateScale)).create(Keys.HAS_SKYLIGHT).get(DimensionType::hasSkyLight)).create(Keys.HAS_CEILING).get(DimensionType::hasCeiling)).create(Keys.PIGLIN_SAFE).get(DimensionType::piglinSafe)).create(Keys.BEDS_USABLE).get(DimensionType::bedWorks)).create(Keys.RESPAWN_ANCHOR_USABLE).get(DimensionType::respawnAnchorWorks)).create(Keys.INFINIBURN).get(dimensionType -> (Tag)dimensionType.infiniburn())).create(Keys.WORLD_FLOOR).get(DimensionType::minY)).create(Keys.HAS_RAIDS).get(DimensionType::hasRaids)).create(Keys.WORLD_HEIGHT).get(DimensionType::height)).create(Keys.WORLD_LOGICAL_HEIGHT).get(DimensionType::logicalHeight)).create(Keys.SPAWN_LIGHT_LIMIT).get(DimensionType::monsterSpawnBlockLightLimit)).create(Keys.SPAWN_LIGHT_RANGE).get(t -> WorldTypeData.lightRange(t.monsterSettings().monsterSpawnLightTest()))).asImmutable(DimensionTypeAccessor.class).create(Keys.AMBIENT_LIGHTING).get(DimensionTypeAccessor::accessor$ambientLight)).create(Keys.FIXED_TIME).get(WorldTypeData::fixedTime)).asImmutable(DimensionTypeBridge.class).create(Keys.CREATE_DRAGON_FIGHT).get(DimensionTypeBridge::bridge$createDragonFight);
    }

    private static Range<Integer> lightRange(IntProvider provider) {
        return Range.intRange(provider.getMinValue(), provider.getMaxValue());
    }

    private static WorldTypeEffect worldTypeEffect(DimensionType type) {
        ResourceKey key = (ResourceKey)type.effectsLocation();
        @Nullable WorldTypeEffect effect = DimensionEffectProvider.INSTANCE.get(key);
        if (effect == null) {
            throw new IllegalStateException(String.format("The effect '%s' has not been registered!", key));
        }
        return effect;
    }

    private static @Nullable MinecraftDayTime fixedTime(DimensionTypeAccessor accessor) {
        OptionalLong fixedTime = accessor.accessor$fixedTime();
        if (!fixedTime.isPresent()) {
            return null;
        }
        return new SpongeMinecraftDayTime(fixedTime.getAsLong());
    }
}

