/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.common.event.SpongeEventContextKeyBuilder;

public final class SpongeEventContextKey<T>
implements EventContextKey<T> {
    private final ResourceKey key;
    private final Type allowed;

    SpongeEventContextKey(SpongeEventContextKeyBuilder<T> builder) {
        this.key = builder.key;
        this.allowed = builder.typeClass;
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    @Override
    public Type allowedType() {
        return this.allowed;
    }

    @Override
    public boolean isInstance(Object value) {
        return value != null && GenericTypeReflector.erase(this.allowed).isInstance(value);
    }

    @Override
    public T cast(Object value) {
        return (T)value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeEventContextKey that = (SpongeEventContextKey)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.allowed, that.allowed);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.allowed);
    }

    public String toString() {
        return new StringJoiner(", ", "EventContextKey[", "]").add("key=" + this.key).add("allowed=" + this.allowed).toString();
    }
}

