/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.ticks.ScheduledTick;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.server.TickTaskBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.world.BlockChange;

public interface IPhaseState<C extends PhaseContext<C>> {
    public static final BiConsumer<CauseStackManager.StackFrame, ? extends PhaseContext<@NonNull ?>> DEFAULT_OWNER_NOTIFIER = (frame, ctx) -> {
        if (ctx.usedFrame == null) {
            ctx.usedFrame = new ArrayDeque<CauseStackManager.StackFrame>();
        }
        ctx.usedFrame.push((CauseStackManager.StackFrame)frame);
        if (ctx.creator != null) {
            frame.addContext(EventContextKeys.CREATOR, ctx.creator);
        }
        if (ctx.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, ctx.notifier);
        }
    };

    public C createPhaseContext(PhaseTracker var1);

    default public BiConsumer<CauseStackManager.StackFrame, C> getFrameModifier() {
        return DEFAULT_OWNER_NOTIFIER;
    }

    default public boolean isInteraction() {
        return false;
    }

    public void unwind(C var1);

    default public void postBlockTransactionApplication(C context, BlockChange blockChange, BlockTransactionReceipt receipt) {
    }

    default public boolean tracksCreatorsAndNotifiers() {
        return true;
    }

    default public boolean doesAllowEntitySpawns() {
        return true;
    }

    default public boolean doesBlockEventTracking(C context) {
        return true;
    }

    default public boolean allowsEntityCollisionEvents() {
        return false;
    }

    default public boolean ignoresBlockEvent() {
        return false;
    }

    default public boolean requiresPost() {
        return true;
    }

    default public void associateNeighborStateNotifier(C unwindingContext, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerLevel minecraftWorld, PlayerTracker.Type notifier) {
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext, C currentPhaseData) {
    }

    default public void appendNotifierPreBlockTick(ServerLevel world, BlockPos pos, C context, LocationBasedTickContext<@NonNull ?> phaseContext) {
        LevelChunk chunk = world.getChunkAt(pos);
        LevelChunkBridge mixinChunk = (LevelChunkBridge)chunk;
        if (chunk != null && !chunk.isEmpty()) {
            mixinChunk.bridge$getBlockCreatorUUID(pos).ifPresent(phaseContext::creator);
            mixinChunk.bridge$getBlockNotifierUUID(pos).ifPresent(phaseContext::notifier);
        }
    }

    default public void appendNotifierToBlockEvent(C context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
    }

    default public void capturePlayerUsingStackToBreakBlock(@Nullable ServerPlayer playerIn, C context) {
    }

    default public boolean allowsEventListener() {
        return true;
    }

    default public ChangeBlock createTransaction(C phaseContext, SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = ((PhaseContext)phaseContext).getTransactor().logBlockChange(originalBlockSnapshot, newState, flags);
        return changeBlock;
    }

    default public BlockChange associateBlockChangeWithSnapshot(C phaseContext, BlockState newState, BlockState currentState) {
        Block newBlock = newState.getBlock();
        Block currentBlock = currentState.getBlock();
        if (currentState.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElse(false).booleanValue() && newBlock == Blocks.WATER || newBlock == Blocks.AIR) {
            return BlockChange.BREAK;
        }
        if (newBlock != currentBlock && !TrackingUtil.forceModify(currentBlock, newBlock)) {
            return BlockChange.PLACE;
        }
        return BlockChange.MODIFY;
    }

    default public boolean shouldProvideModifiers(C phaseContext) {
        return true;
    }

    default public boolean isRestoring() {
        return false;
    }

    default public Supplier<SpawnType> getSpawnTypeForTransaction(C context, net.minecraft.world.entity.Entity entityToSpawn) {
        if (entityToSpawn instanceof ItemEntity) {
            return SpawnTypes.DROPPED_ITEM;
        }
        return SpawnTypes.PASSIVE;
    }

    default public SpawnEntityEvent createSpawnEvent(C context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<net.minecraft.world.entity.Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        return SpongeEventFactory.createSpawnEntityEvent(currentCause, collect.stream().map(t -> (Entity)t.first()).collect(Collectors.toList()));
    }

    default public void populateLootContext(C phaseContext, LootContext.Builder lootBuilder) {
    }

    default public Operation getBlockOperation(C phaseContext, SpongeBlockSnapshot original, SpongeBlockSnapshot result) {
        return this.associateBlockChangeWithSnapshot(phaseContext, result.nativeState(), original.nativeState()).toOperation();
    }

    default public void foldContextForThread(C context, TickTaskBridge returnValue) {
    }

    default public void associateScheduledTickUpdate(C asContext, ServerLevel level, ScheduledTick<?> entry) {
    }

    default public boolean isApplyingStreams() {
        return false;
    }

    default public Supplier<ResourceKey> attemptWorldKey(C context) {
        return () -> {
            throw new IllegalStateException("Unable to provide a ServerLevel");
        };
    }

    default public @Nullable ClickContainerEvent createContainerEvent(C context, Cause cause, ServerPlayer serverPlayer, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return null;
    }

    default public boolean doesContainerCaptureEntitySpawn(C context, net.minecraft.world.entity.Entity entityIn) {
        return false;
    }

    default public boolean captureModifiedContainer(AbstractContainerMenu container) {
        return false;
    }
}

