/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.chunk.LevelChunk$BoundTickingBlockEntityAccessor;
import org.spongepowered.common.accessor.world.level.chunk.LevelChunk$RebindableTickingBlockEntityWrapperAccessor;
import org.spongepowered.common.accessor.world.level.chunk.LevelChunkAccessor;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.block.entity.BlockEntityBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.FluidTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

public final class TrackingUtil {
    public static final Marker ENTITY_TICK = MarkerManager.getMarker((String)"ENTITY TICK");
    public static final Marker BLOCK_ENTITY_TICK = MarkerManager.getMarker((String)"TILE ENTITY TICK");
    public static final Marker PLAYER_TICK = MarkerManager.getMarker((String)"PLAYER TICK");
    public static final Marker BLOCK_TICK = MarkerManager.getMarker((String)"BLOCK TICK");
    public static final Marker FLUID_TICK = MarkerManager.getMarker((String)"FLUID TICK");
    public static final int WIDTH = 40;

    public static void tickEntity(Consumer<net.minecraft.world.entity.Entity> consumer, net.minecraft.world.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        if (!((TrackableBridge)entity).bridge$shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext(PhaseTracker.SERVER).source(entity);
        try (EntityTickContext context = tickContext;){
            if (entity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)entity).tracker$getNotifierUUID().ifPresent(context::notifier);
                ((CreatorTrackedBridge)entity).tracker$getCreatorUUID().ifPresent(context::creator);
            }
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(ENTITY_TICK, () -> "Wrapping Entity Tick: " + entity.toString());
            consumer.accept(entity);
            if (ShouldFire.MOVE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalMoveEntityEvent(entity);
            }
            if (ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalRotateEntityEvent(entity);
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, tickContext);
        }
    }

    private static Optional<BlockEntity> getTickingBlockEntity(TickingBlockEntity ticker) {
        if (ticker instanceof LevelChunk$BoundTickingBlockEntityAccessor) {
            LevelChunk$BoundTickingBlockEntityAccessor beAccessor = (LevelChunk$BoundTickingBlockEntityAccessor)ticker;
            return Optional.of(beAccessor.accessor$blockEntity());
        }
        if (ticker instanceof LevelChunk$RebindableTickingBlockEntityWrapperAccessor) {
            LevelChunk$RebindableTickingBlockEntityWrapperAccessor beAccessor = (LevelChunk$RebindableTickingBlockEntityWrapperAccessor)ticker;
            return TrackingUtil.getTickingBlockEntity(beAccessor.accessor$ticker());
        }
        if (ticker == LevelChunkAccessor.accessor$NULL_TICKER()) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void tickTileEntity(TrackedWorldBridge mixinWorldServer, TickingBlockEntity tile) {
        Preconditions.checkNotNull((Object)tile, (Object)"Cannot capture on a null ticking tile entity!");
        Optional<BlockEntity> tickingBlockEntity = TrackingUtil.getTickingBlockEntity(tile);
        if (!tickingBlockEntity.isPresent()) {
            return;
        }
        BlockEntity blockEntity = tickingBlockEntity.get();
        BlockEntityBridge mixinTileEntity = (BlockEntityBridge)tickingBlockEntity.get();
        BlockPos pos = blockEntity.getBlockPos();
        @Nullable LevelChunkBridge chunk = ((ActiveChunkReferantBridge)blockEntity).bridge$getActiveChunk();
        if (!((TrackableBridge)blockEntity).bridge$shouldTick()) {
            return;
        }
        if (chunk == null) {
            ((ActiveChunkReferantBridge)blockEntity).bridge$setActiveChunk((TrackedLevelChunkBridge)blockEntity.getLevel().getChunkAt(blockEntity.getBlockPos()));
        }
        TileEntityTickContext context = TickPhase.Tick.TILE_ENTITY.createPhaseContext(PhaseTracker.SERVER).source(mixinTileEntity);
        try (@NonNull TileEntityTickContext phaseContext = context;){
            Set<net.minecraft.server.level.ServerPlayer> players;
            if (blockEntity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)blockEntity).tracker$getNotifierUUID().ifPresent(phaseContext::notifier);
                ((CreatorTrackedBridge)blockEntity).tracker$getCreatorUUID().ifPresent(phaseContext::creator);
            }
            phaseContext.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_ENTITY_TICK, () -> "Wrapping Entity Tick: " + tile.toString());
            tile.tick();
            if (blockEntity instanceof ViewableInventoryBridge && (players = ((ViewableInventoryBridge)blockEntity).viewableBridge$getViewers()).size() > 0) {
                players.forEach(player -> player.containerMenu.broadcastChanges());
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, context);
        }
        if (blockEntity.isRemoved()) {
            ((ActiveChunkReferantBridge)blockEntity).bridge$setActiveChunk(null);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void updateTickBlock(TrackedWorldBridge mixinWorld, BlockState block, BlockPos pos, RandomSource random) {
        ServerLevel world = (ServerLevel)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(block, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(PhaseTracker.getCauseStackManager().currentCause(), snapshot);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.getX(), pos.getY(), pos.getZ()).state((org.spongepowered.api.block.BlockState)block).build();
        BlockTickContext phaseContext = TickPhase.Tick.BLOCK.createPhaseContext(PhaseTracker.SERVER).source(locatable);
        PhaseContext<@NonNull BlockTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_TICK, () -> "Wrapping Block Tick: " + block.toString());
            block.tick(world, pos, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    public static void updateTickFluid(TrackedWorldBridge mixinWorld, FluidState fluidState, BlockPos pos) {
        ServerLevel world = (ServerLevel)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        BlockState blockState = fluidState.createLegacyBlock();
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(blockState, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(PhaseTracker.getCauseStackManager().currentCause(), snapshot);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.getX(), pos.getY(), pos.getZ()).state((org.spongepowered.api.block.BlockState)blockState).build();
        FluidTickContext phaseContext = TickPhase.Tick.FLUID.createPhaseContext(PhaseTracker.SERVER).source(locatable).fluid(fluidState);
        PhaseContext<@NonNull FluidTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (FluidTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(FLUID_TICK, () -> "Wrapping Fluid Tick: " + fluidState.toString());
            fluidState.tick((Level)world, pos);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void randomTickBlock(TrackedWorldBridge mixinWorld, BlockState state, BlockPos pos, RandomSource random) {
        ServerLevel world = (ServerLevel)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(PhaseTracker.getCauseStackManager().currentCause(), currentTickBlock);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.getX(), pos.getY(), pos.getZ()).state((org.spongepowered.api.block.BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.RANDOM_BLOCK.createPhaseContext(PhaseTracker.SERVER).source(locatable);
        PhaseContext<@NonNull BlockTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_TICK, "Wrapping Random Block Tick: {}", (Object)state);
            state.randomTick(world, pos, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void randomTickFluid(TrackedWorldBridge mixinWorld, FluidState state, BlockPos pos, RandomSource random) {
        ServerLevel world = (ServerLevel)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state.createLegacyBlock(), pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(PhaseTracker.getCauseStackManager().currentCause(), currentTickBlock);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.getX(), pos.getY(), pos.getZ()).state((org.spongepowered.api.block.BlockState)state.createLegacyBlock()).build();
        FluidTickContext phaseContext = TickPhase.Tick.RANDOM_FLUID.createPhaseContext(PhaseTracker.SERVER).source(locatable).fluid(state);
        PhaseContext<@NonNull FluidTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull FluidTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(FLUID_TICK, () -> "Wrapping Random Fluid Tick: " + state.toString());
            state.randomTick((Level)world, pos, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    public static boolean fireMinecraftBlockEvent(ServerLevel worldIn, BlockEventData event, BlockState currentState) {
        Locatable source;
        TrackableBlockEventDataBridge blockEvent = (TrackableBlockEventDataBridge)event;
        Locatable locatable = source = blockEvent.bridge$getTileEntity() != null ? blockEvent.bridge$getTileEntity() : blockEvent.bridge$getTickingLocatable();
        if (source == null) {
            return currentState.triggerEvent((Level)worldIn, event.pos(), event.paramA(), event.paramB());
        }
        BlockEventTickContext phaseContext = TickPhase.Tick.BLOCK_EVENT.createPhaseContext(PhaseTracker.SERVER);
        phaseContext.source(source);
        UUID user = ((TrackableBlockEventDataBridge)event).bridge$getSourceUserUUID();
        if (user != null) {
            phaseContext.creator = user;
            phaseContext.notifier = user;
        }
        boolean result = true;
        try (BlockEventTickContext o = phaseContext;){
            o.buildAndSwitch();
            phaseContext.setEventSucceeded(currentState.triggerEvent((Level)worldIn, event.pos(), event.paramA(), event.paramB()));
            result = phaseContext.wasNotCancelled();
        }
        return result;
    }

    static boolean forceModify(Block originalBlock, Block newBlock) {
        if (originalBlock instanceof RepeaterBlock && newBlock instanceof RepeaterBlock) {
            return true;
        }
        if (originalBlock instanceof RedstoneTorchBlock && newBlock instanceof RedstoneTorchBlock) {
            return true;
        }
        return originalBlock instanceof RedstoneLampBlock && newBlock instanceof RedstoneLampBlock;
    }

    private TrackingUtil() {
    }

    public static @Nullable UUID getNotifierOrOwnerFromBlock(ServerLevel world, BlockPos blockPos) {
        LevelChunkBridge mixinChunk = (LevelChunkBridge)world.getChunkAt(blockPos);
        UUID notifier = mixinChunk.bridge$getBlockNotifierUUID(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        return mixinChunk.bridge$getBlockCreatorUUID(blockPos).orElse(null);
    }

    public static Supplier<IllegalStateException> throwWithContext(String s, PhaseContext<?> phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s : %s", "State", phaseContext.state);
            printer.addWrapped(40, "%s :", "PhaseContext");
            PhasePrinter.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeCommon.logger(), org.apache.logging.log4j.Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(PhaseContext<@NonNull ?> context) {
        TransactionalCaptureSupplier transactor = context.getTransactor();
        if (transactor.isEmpty()) {
            return false;
        }
        return transactor.processTransactions(context);
    }

    public static void associateTrackerToTarget(BlockChange blockChange, BlockTransactionReceipt receipt, UUID uuid) {
        BlockSnapshot finalSnapshot = receipt.finalBlock();
        SpongeBlockSnapshot spongeSnapshot = (SpongeBlockSnapshot)finalSnapshot;
        BlockPos pos = spongeSnapshot.getBlockPos();
        Block block = ((BlockState)spongeSnapshot.state()).getBlock();
        spongeSnapshot.getServerWorld().map(world -> world.getChunkAt(pos)).map(chunk -> (LevelChunkBridge)chunk).ifPresent(spongeChunk -> {
            PlayerTracker.Type trackerType = blockChange == BlockChange.PLACE ? PlayerTracker.Type.CREATOR : PlayerTracker.Type.NOTIFIER;
            spongeChunk.bridge$addTrackedBlockPosition(block, pos, uuid, trackerType);
        });
    }

    public static void setCreatorReference(List<Entity> entities, net.minecraft.server.level.ServerPlayer player) {
        for (Entity currentEntity : entities) {
            if (currentEntity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)((Object)currentEntity)).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, ((ServerPlayer)player).uniqueId());
                continue;
            }
            currentEntity.offer(Keys.CREATOR, player.getUUID());
        }
    }

    public static void addTileEntityToBuilder(BlockEntity existing, SpongeBlockSnapshot.BuilderImpl builder) {
        try {
            CompoundTag compound = existing.saveWithFullMetadata();
            builder.addUnsafeCompound(compound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String phaseStateToString(String type, IPhaseState<?> state) {
        return TrackingUtil.phaseStateToString(type, null, state);
    }

    public static String phaseStateToString(String type, @Nullable String extra, IPhaseState<?> state) {
        String name = state.getClass().getSimpleName();
        name = name.replace("Phase", "");
        name = name.replace("State", "");
        name = name.replace(type, "");
        if (extra == null) {
            return type + "{" + name + "}";
        }
        if (name.isEmpty()) {
            return type + "{" + extra + "}";
        }
        return type + "{" + name + ":" + extra + "}";
    }

    public static SpongeBlockSnapshot createPooledSnapshot(BlockState state, BlockPos pos, BlockChangeFlag updateFlag, int limit, @Nullable BlockEntity blockEntity, Supplier<ServerLevel> worldSupplier, Supplier<Optional<UUID>> creatorSupplier, Supplier<Optional<UUID>> notifierSupplier) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.reset();
        builder.blockState(state).world(worldSupplier.get()).position(VecHelper.toVector3i(pos));
        creatorSupplier.get().ifPresent(builder::creator);
        notifierSupplier.get().ifPresent(builder::notifier);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        builder.flag(updateFlag);
        return builder.build();
    }
}

