/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ShiftCraftingResultTransaction;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public class ClickMenuTransaction
extends ContainerBasedTransaction {
    private final ServerPlayer player;
    private final int slotNum;
    private final int buttonNum;
    private final ClickType clickType;
    private final @Nullable Slot slot;
    private final ItemStackSnapshot cursor;

    public ClickMenuTransaction(Player player, AbstractContainerMenu menu, int slotNum, int buttonNum, ClickType clickType, @Nullable Slot slot, ItemStackSnapshot cursor) {
        super(menu);
        this.player = (ServerPlayer)player;
        this.slotNum = slotNum;
        this.buttonNum = buttonNum;
        this.clickType = clickType;
        this.slot = slot;
        this.cursor = cursor;
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        ItemStackSnapshot resultingCursor = ItemStackUtil.snapshotOf(this.player.containerMenu.getCarried());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(this.cursor, resultingCursor);
        @Nullable ClickContainerEvent event = context.createContainerEvent(cause, this.player, (Container)this.menu, cursorTransaction, slotTransactions, entities, this.buttonNum, this.slot);
        return Optional.ofNullable(event);
    }

    @Override
    public boolean absorbShiftClickResult(PhaseContext<@NonNull ?> context, ShiftCraftingResultTransaction transaction) {
        this.shiftCraftingResult = transaction.itemStack;
        return true;
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((Player)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((Player)this.player, event);
    }

    @Override
    boolean isContainerEventAllowed(PhaseContext<@NonNull ?> context) {
        if (!(context instanceof InventoryPacketContext)) {
            return false;
        }
        int containerId = ((ServerboundContainerClickPacket)((InventoryPacketContext)context).getPacket()).getContainerId();
        return containerId != this.player.containerMenu.containerId;
    }
}

